/***************************************************************************
                          search.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: search.cpp
	Last generated: Thu Jul 20 23:16:10 2000

 *********************************************************************/

#include "search.h"

#define Inherited SearchData


Search::Search(KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L):
	Inherited(parent, name) {
	_url=url;
	setTabOrder(search, start);
	setTabOrder(start, fulltext);
	setTabOrder(fulltext, result);
  connect(result,   SIGNAL(open(Oid, const char *, bool)), this, SLOT(open(Oid, const char *, bool)));
	connect(search, SIGNAL(returnPressed()), this, SLOT(startSearch()));
	try {
		base=new MyKaspaBase(conn);
		ASSERT(base);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

Search::~Search() { delete base; }

void Search::startSearch() {
	try {
		if(!strlen(search->text())) return;
		setWorkingGUI();

		QString w;
		if(exact->isChecked()) w=" = '";
		else w=" ~* '";
		w+=search->text(); w+="'";

		QString s("where title"); s+=w;
		result->set(base->getPartTitles(s));
		result->append(base->getPublTitles(s));
		result->append(base->getNoteTitles(s));
		s="where lastname"; s+=w;
		result->append(base->getAuthorNames(s));
		s="where name"; s+=w;
		result->append(base->getPublisherNames(s));

		if(fulltext->isChecked()) {
			w=w.lower();
			s="where word.dictionaryno=dictionary.oid and dictionary.word"+w;
			AuthorName *an=0L; PartTitle *pt=0L; PublTitle *pbt=0L; NoteTitle *nt=0L; PartDataName *pdt=0L;
			base->search(s, &an, &pt, &pbt, &nt, &pdt);
			result->append(an);
			result->append(nt);
			result->append(pbt);
			result->append(pt);
			result->append(pdt);
		}	
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Search::open(Oid o, const char *data, bool w) {
	if(!strcmp(data, "note")) requestNote(o, w);
	if(!strcmp(data, "publication")) requestPublication(o, w);
	if(!strcmp(data, "part")) requestPart(o, w);
	if(!strcmp(data, "partmemo")) requestPartMemo(o, w);
	if(!strcmp(data, "author")) requestAuthor(o, w);
	if(!strcmp(data, "publisher")) requestPublisher(o, w);
	if(!strcmp(data, "bibliography")) requestBibliography(o, w);
	if(!strcmp(data, "partdata")) requestHTMLData(o, w);
}






