/***************************************************************************
                          qkaspaevent.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          qkaspaevent.h  -  description                              
                             -------------------                                         
    begin                : Mon Jan 31 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QKASPAEVENT_H
#define QKASPAEVENT_H

#include <qevent.h>
#include <kaspaurl.h>

/**
  *@author Jan Mueller
  */

class QKaspaEvent : public QEvent {
	KaspaURL _url;
	char *caption;

private:
	QKaspaEvent(const QKaspaEvent&);

public:
	QKaspaEvent(const char *u=0, const char *c=0);
	QKaspaEvent(QKaspaEvent& e): QEvent(User), _url(e._url),
																caption(e.caption?qstrdup(e.caption):0L) { }
	virtual ~QKaspaEvent() { delete caption; }
	const KaspaURL& url() { return _url; }
	void setUrl(const char *u) { _url=u; }
	const char *getCaption() { return caption; }
	void setCaption(const char *c) { if(c) caption=qstrdup(c);	else { delete caption; caption=0; } }
};

#endif


















