/***************************************************************************
                          publication.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: publication.h
	Last generated: Fri Sep 24 20:59:21 1999

 *********************************************************************/

#ifndef Publication_included
#define Publication_included

#include "publicationdata.h"
#include "publbase.h"
#include <kaspaurl.h>

class Publication : public PublicationData
{
    Q_OBJECT
private:
		Publication(const Publication&);
		Publication& operator=(const Publication&);

protected:
    PublBase *publ;
		void save(bool block=false);
		KaspaURL _url;


public:
    /** Load notice from WHERE clause. Must not return more than one row. Calls init().
     */
    Publication(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
				Clears any messages in the statusline.
     */
    virtual ~Publication();

    virtual const char *url() { return _url; }

    /** Creates a toolbar and alters the menu. Called by the constructors.
     */
    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return publ->isWorking(); }
    virtual bool isReadOnly() { return publ->isReadOnly(); }
    virtual bool closeRequest();

    virtual void setFields();

    KToolBar *getToolBar();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

    virtual void insAuthor();
    virtual void remAuthor();
    virtual void newAuthor();
    virtual void newPart();
    virtual void remPart();
    virtual void showBiblio();
    virtual void newLink();
    virtual void remLink();
    virtual void insLink();
		virtual void insPublisherOrJournal();
		virtual void newPublisherOrJournal();
		virtual void showPublisherOrJournal();
		virtual void showLinks();
		
		virtual void entrytype_changed(const QString& s);
};
#endif // Publication_included















