/***************************************************************************
                          parser.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: parser.cpp
	Last generated: Tue Jul 25 23:51:50 2000

 *********************************************************************/

#include "parser.h"
#include <qpainter.h>
#include <qstring.h>
#include <qcstring.h>
#include <kmessagebox.h>
#include <kstddirs.h>

#define Inherited ParserData

void Parser::startParsing() {
	if(rebuild->isChecked())
		if(!KMessageBox::questionYesNo(this, "Rebuild the index?", "Parser"))
			return;
	start(rebuild->isChecked());
}

void Parser::start(bool rebuild) {
	output->setText("");
	process.clearArguments();
	process<<locate("exe", "kaspaparser");
	process<<"-l"; process<<QString().setNum(cutwords);
	for(unsigned int i=0; i<masks.count(); i++) {
		process<<"-f"; process<<QString(masks.at(i));
	}
	if(rebuild) process<<"-r";
	process.start(KProcess::NotifyOnExit, KProcess::Stdout);
	setupGUI();
};

Parser::Parser(int limit, QStrList m, KaspaURL url, Sql *conn, QWidget* parent, const char* name):
	Inherited(parent, name) {
	masks.setAutoDelete(true);
	startparsing->setEnabled(true);
	cancelparsing->setEnabled(false);
	setLimit(limit);
	setMasks(m);
	connect(&process, SIGNAL(processExited(KProcess *)), this, SLOT(slotHandleExit(KProcess *)));
	connect(&process, SIGNAL(receivedStdout(KProcess *, char*, int)),
					this, SLOT(slotHandleStdout(KProcess *, char*, int)));

	_url=url;
	p=qstrdup("kaspa://parser");

/*	if(url.command()=="update") start(false);
	if(url.command()=="rebuild") { start(true); rebuild->setChecked(true); } */
}

void Parser::slotHandleExit(KProcess* p) {
	setupGUI();
}

void Parser::slotHandleStdout (KProcess *proc, char *buffer, int buflen) {
	QCString s(buffer, buflen);
	output->append(s);
	output->setUpdatesEnabled(false);
	output->center(0, output->contentsHeight()-5, 0, 0);
	output->setUpdatesEnabled(true);	
	/*
	output->repaintContents(output->contentsX(),
										 	    output->contentsY(),
	                        output->contentsX()+output->contentsWidth(),
	                        output->contentsY()+output->contentsHeight());
*/	
}

Parser::~Parser() { delete p; }

void Parser::setWorkingGUI() {
	ParserData::setWorkingGUI();
	cancelparsing->setEnabled(true);
	startparsing->setEnabled(false);
	rebuild->setEnabled(false);

}

void Parser::setReadWriteGUI() {
	ParserData::setReadWriteGUI();
	startparsing->setEnabled(true);
	rebuild->setEnabled(true);
 	cancelparsing->setEnabled(false);
}

void Parser::setReadOnlyGUI() {
	ParserData::setReadOnlyGUI();
	lockGUI();
}

void Parser::setLimit(int limit) {
	cutwords=limit;
}	

void Parser::setMasks(QStrList m) {
	masks.clear();
	for(unsigned int i=0; i<m.count(); i++)
		masks.append(qstrdup(m.at(i)));
}




