/***************************************************************************
                          fileiodlg.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: fileio.cpp
	Last generated: Sat Apr 1 16:05:39 2000

 *********************************************************************/

#include <kapp.h>
#include <kmessagebox.h>

#include "fileiodlg.h"
#include "qprogressdialog.h"
#include "partdatabase.h"
#include <klocale.h>

#define Inherited FileIODlgData

FileIODlg::FileIODlg(KaspaURL url, Sql *conn, QWidget* parent, const char* name):	
		Inherited( parent, name ) {
	PublTitle *pt=0L;
	setTabOrder(indexbutton, exportbutton);
	setTabOrder(exportbutton, importbutton);
	setTabOrder(importbutton, delbutton);
//	setTabOrder(delbutton, selbutton);
//	setTabOrder(selbutton, linkbutton);
	internallist->setSelectionMode(QListBox::Extended);
	externallist->setSelectionMode(QListBox::Extended);
	connect(externallist, SIGNAL(selected(int)), this, SLOT(dirSelected(int)));

	try {
		running=false;
		_url=url;
		sql=conn;
		partfiles=0L;
		part=new PartBase(url.where(), conn);
		ASSERT(part);
		dir = new QDir("/");
		pathlabel->setText("/");

		if(!part->isValid()) setInvalidGUI();

		pt=part->getPartPubl();
		if(pt) {
			publtitle->setText(pt->getTitle());
			delete pt;
			pt=0L;
		}
		readPartData();
		parttitle->setText(part->getTitle());

		readDirData();

		indexfile->setText(i18n("No File Selected"));
		for(PartDataName *p=partfiles; p; p=p->getNext())
			if(p->getOid()==(part->getFirstFile()))
					indexfile->setText(p->getTitle());
	} catch(KaspaErr& err) {
		handleWarning(err);
		delete pt;
	}
}

void FileIODlg::reset() {
	try {
		readDirData();
		readPartData();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void FileIODlg::dirSelected(int index) {
	if(dir->cd(externallist->currentText())) {
  	readDirData();
	  pathlabel->setText(dir->path());
	}
}

void FileIODlg::selectAll() {
    externallist->selectAll(true);
}

void FileIODlg::readPartData() {
	internallist->clear();
	partfiles=part->getFiles();
	for(PartDataName *p=partfiles; p; p=p->getNext())
		internallist->insertItem(p->getTitle());
}

void FileIODlg::readDirData() {
	externallist->clear();
	externallist->insertStringList(dir->entryList(QDir::DefaultFilter, QDir::DirsFirst));
}

void FileIODlg::setIndexFile() {
	try {
		QString s(internallist->text(internallist->currentItem()));
		indexfile->setText(s);	
		for(PartDataName *p=partfiles; p; p=p->getNext())
			if(strcmp(p->getTitle(), s)==0) {
				part->setFirstFile(p->getOid());
				part->flush();
			}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void FileIODlg::deleteItem() {
	try {
		// Any file marked?
		int count=0;
		for(uint i=0; i<internallist->count(); i++)
			if(internallist->isSelected(i)) count++;

		if(count && (KMessageBox::questionYesNo(this, "Delete Files?", "Delete Rec") == KMessageBox::Yes)) {
			QProgressDialog pd("Deleting Files", "Abort", count, this);

			// delete files...	
			int j=0;
			for(uint i=0; i<internallist->count(); i++)
				if(internallist->isSelected(i)) {
					j++;
					char *s=esc4sql(internallist->text(i));
					part->deleteFile(s);
					delete s;
					pd.setProgress(j);
				}
			pd.setProgress(count);
			reset();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void FileIODlg::exportItem() {
PartDataBase *file=0L;
QProgressDialog pd(this);
try {
	// Setup...
	pd.setLabelText("Copying files...");
	pd.setCancelButtonText("Abort Copy");
	pd.setTotalSteps(internallist->count());
	pd.setProgress(0);

	// for each file...
	for(uint i=0; i<internallist->count(); i++) {

		if(!internallist->isSelected(i)) continue;

		// Build path+filename and setup progressbar...
		QString n(dir->path());
		n+="/"+internallist->text(i);
		debug("FileIODlg::exportItem() - file: %s", (const char *) n);
		pd.setLabelText(n);

		// Open file...
		QFile f(n);
		if(!f.open(IO_WriteOnly))
			throw KaspaErr("Unable to open file for writing!");

		// Write buffer...
		QString q("where partno=");
		q+=QString().setNum(part->id());
		q+=" and filename='"; q+=internallist->text(i); q+="'";
		file=new PartDataBase(q, DB_NAME);
		long len;
		const unsigned char *buf=file->getData(len);
		if(f.writeBlock((char *)buf, (uint) len)!=len)
			throw KaspaErr("Unable to write to file!");

		// Setup progressbar and internallist-widget...
		pd.setProgress(i);

		// cleanup...
		delete file; file=0L;
	}
	pd.setProgress(internallist->count());
	readDirData();
} catch(KaspaErr& err) {
		pd.setProgress(internallist->count());
		delete file;
		handleWarning(err);
	}
}	


void FileIODlg::importItem() {
char *buf=0L;
PartDataBase *file=0L;
PartDataName *internalfiles=0L;
QProgressDialog pd(this);
try {
	// Setup...
	internalfiles=part->getFiles();
	pd.setLabelText("Copying files...");
	pd.setCancelButtonText("Abort Copy");
	pd.setTotalSteps(externallist->count());
	pd.setProgress(0);
	debug("FileIODlg::importItem() - count: %d", externallist->count());

	// for each file...
	for(uint i=0; i<externallist->count(); i++) {
	  if(!externallist->isSelected(i)) continue;

		// Check, if filename  already used...
		for(PartDataName *p=internalfiles; p; p=p->getNext())
			if(strcmp(externallist->text(i), p->getFileName())==0)
				throw KaspaErr("File already in Database");

		// Build path+filename and setup progressbar...
		QString n(dir->path());
		n+="/"+externallist->text(i);
		debug("FileIODlg::importItem() - file: %s", (const char *) n);
		pd.setLabelText(externallist->text(i));
		// Read file...
		QFile f(n);
		if(!f.open(IO_ReadOnly))
			throw KaspaErr("Unable to open file for reading!");
		buf=new char[f.size()];
		if(f.readBlock(buf, f.size())!=int(f.size()))
			throw KaspaErr("Unable to read from file!");

		// New PartData-record...
		file=new PartDataBase(part->id(), sql);
		file->setFilename(externallist->text(i));
		file->setData((unsigned char*)buf, long(f.size()));
		
		// set types
		debug("FileIODlg::importItem():"+externallist->text(i));
		QRegExp pdf("pdf$");
		pdf.setCaseSensitive(false);
		if(pdf.find(externallist->text(i),0)!=-1)
 		  file->setType("pdf");
 		
 		QRegExp ps("ps$");
		ps.setCaseSensitive(false);
		if(ps.find(externallist->text(i),0)!=-1)
 		  file->setType("ps");

		QRegExp dvi("dvi$");
		dvi.setCaseSensitive(false);
		if(dvi.find(externallist->text(i),0)!=-1)
 		  file->setType("dvi");

 		   		
 		QRegExp html("htm?$");
		html.setCaseSensitive(false);
		if(html.find(externallist->text(i),0)!=-1)
 		  file->setType("html");
 		
 		QRegExp txt("txt$");
		txt.setCaseSensitive(false);
		if(txt.match(externallist->text(i),0)!=-1)
 		  file->setType("txt");
 		
		file->flush();
		delete file; file=0L;

		// Setup progressbar and internallist-widget...
		pd.setProgress(i);
		internallist->insertItem(externallist->text(i));

		// cleanup...
		delete buf; buf=0L;
	}
	pd.setProgress(externallist->count());
	delete internalfiles;
	reset();
} catch(KaspaErr& err) {
		pd.setProgress(externallist->count());
		delete internalfiles;
		delete buf;
		delete file;
		handleWarning(err);
	}
}	

FileIODlg::~FileIODlg() {
	delete dir;
	delete partfiles;
	delete part;
}
