/***************************************************************************
                          DataView.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: DataView.cpp
	Last generated: Sun Sep 26 14:18:38 1999

 *********************************************************************/



#include "dataview.h"

#define Inherited DataViewData

#include "resource.h"

#include <kapp.h>
#include <qaccel.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <qclipboard.h>
#include "selectiondlg.h"
#include "notetreedlg.h"
#include "kaspawidget.h"
#include <klocale.h>
#include <klibloader.h>
#include <stdio.h>
#include <qlayout.h>
#include <ktrader.h>
#include <qcstring.h>
#include <kmimemagic.h>
#include <kservice.h>

#define Inherited DataViewData

CommandSetup dataviewcs[] = {	{ID_HTML_SHOWPART,  RW+RO},
															{ID_HTML_NEWLINK, 	RW+RO},
															{ID_HTML_INSLINK, 	RW+RO},
															{ID_HTML_REMLINK,		RW+RO},
															{ID_HTML_RESET,			RW+RO+INV} };

															
// DataViewBase-Constructor reads row matching WHERE-Clause.
DataView::DataView(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name), handling_request(false), part(0L)
{
  tmpfiles.setAutoDelete(true);
  debug("DataView::DataView(QString, QWidget, char*)");
  data = new PartDataBase(url.where(), conn);
  ASSERT(data);
  QString s("kaspa://partdata#where oid="); s+=QString().setNum(data->id());
  _url=s;
  connect(notes, SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));

  long len;
  const unsigned char *buf=data->getData(len);
  QByteArray ba;
  ba.duplicate((const char *)buf, len);

	KMimeMagicResult *mime=KMimeMagic::self()->findBufferFileType(ba, data->getFilename());
	KTrader::OfferList offers = KTrader::self()->query(mime->mimeType(), "'KParts/ReadOnlyPart' in ServiceTypes");
	if(offers.count()>0) {
	  debug("DataView::DataView(QString, QWidget, char*): offers.count()>0");
  	KService::Ptr ptr = offers.first();
  	if(ptr) {
		  debug("DataView::DataView(QString, QWidget, char*): ptr!=0");
    	KLibFactory *factory = KLibLoader::self()->factory( ptr->library() );
	    if (factory)
		  {
    	  debug("DataView::DataView(QString, QWidget, char*): factory!=0");
				part = (KParts::ReadOnlyPart *)factory->create(viewframe, ptr->name(), "KParts::ReadOnlyPart");
		    part->openURL("file:/"+oid2file());
 				layout=new QBoxLayout(viewframe, QBoxLayout::Down);
				layout->addWidget(part->widget(), 1);
	  		layout->activate();
		  }
		}
	}
  notes->setTitle("Links");
}

DataView::~DataView()
{
	debug("DataView::~DataView()");
	delete data;
  for(unsigned int i=0; i<tmpfiles.count(); i++) {
	  tmpfiles.at(i)->remove();
	}
  emit modifyGUI(0L);
}

QString DataView::oid2file() {
  long len;
	const unsigned char *buf=data->getData(len);
	QString fname=tmpnam(0L);
	debug("DataView::oid2file() - "+fname);
	QFile *f=new QFile(fname);
  if (!f->open(IO_WriteOnly) )
    throw KaspaErr("Kann kein temporres File ffnen!");
	f->writeBlock((const char *)buf, len);
  f->close();
  tmpfiles.append(f);
  return fname;
}

bool DataView::isValid() {
	try {
	  return data->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}


void DataView::reread() {
	try {
		setWorkingGUI();
  	data->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	  setFields();
}

void DataView::setFields() {
  if(isValid()) {
		setWorkingGUI();

		try {
			Title *p;
			if((p=data->getPublTitle())) publtitle->setText(p->getTitle());
			else throw KaspaErr("File has no Publication!");

			if((p=data->getPartTitle())) parttitle->setText(p->getTitle());
			else throw KaspaErr("File has no Part!");

		  filename->setText(data->getFilename());
		
		  notes->set(data->getLinks());
		  if(part)
        emit modifyGUI(part);
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}


void DataView::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&INV)==INV));
}	

void DataView::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&RW)==RW));
}

void DataView::setWorkingGUI() {
	Inherited::setWorkingGUI();
  notes->setEnabled(FALSE);
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&WORK)==WORK));
}

void DataView::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	lockGUI();
	notes->setEnabled(TRUE);
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&RO)==RO));
}



bool DataView::closeRequest() {
  return TRUE;
}
	
void DataView::newLink() {
	try {
		setWorkingGUI();
		Oid o=data->createNote();
		requestNote(o);
		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void DataView::insLink() {
	try {
		SelectionDlg dlg(data->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			data->insertLink(o);
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void DataView::remLink() {
	try {
		Oid o=notes->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		data->removeLink(o);
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void DataView::showPart() {
	requestPart(data->getPartNo());
}


KToolBar *DataView::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("newnote.xpm"), ID_HTML_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.xpm"), ID_HTML_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.xpm"), ID_HTML_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("showpart.xpm"), ID_HTML_SHOWPART, SIGNAL(clicked()),
				this, SLOT(showPart()), true, i18n("Show Part") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("reload.xpm"), ID_HTML_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}

