/***************************************************************************
                          partbase.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <assert.h>
#include "partbase.h"

#define Inherited Table

// Creates new Part
PartBase::PartBase(Oid publ, Sql *conn):Inherited("part", conn) {
  initNew(publ);
}

PartBase::PartBase(Oid publ, const char *dbname):Inherited("part", dbname) {
  initNew(publ);
}

void PartBase::initNew(Oid publ) {
  PartRec *part=new PartRec;
  assert(part);
  part->empty();
  part->id.set(newPart(publ));
  init(part);
  _where="where oid=";
  _where+=part->id.get();
}

PartBase::PartBase(const char *where, Sql *conn):Inherited("part", conn) {
  initWhere(where);
}

PartBase::PartBase(const char *where, const char *dbname):Inherited("part", dbname) {
	initWhere(where);
}

void PartBase::initWhere(const char *where) {
  PartRec *part=getPart(where);
  if(!part) {
    part=new PartRec;
    assert(part);
    part->empty();
  }
  init(part);
	if(where) _where=where;
	else _where="";
}

PartBase::~PartBase() {
}

const char *PartBase::getTitle() {
  return part()->title.get();
}

const char *PartBase::getPages() {
  return part()->pages.get();
}

const char *PartBase::getLanguage() {
  return part()->language.get();
}

const char *PartBase::getMemo() {
  return part()->memo.get();
}

const char *PartBase::getBibTex() {
  return part()->bibtex.get();
}

bool PartBase::getCreateBibTex() {
  return part()->createbibtex.get();
}

const char *PartBase::getKey() {
  return part()->key.get();
}

Oid PartBase::getFirstFile() {
  return part()->intro.get();
}

int PartBase::getNumber() {
  return part()->partno.get();
}

const char *PartBase::getModified() {
  return part()->modified.get();
}

const char *PartBase::getCreated() {
  return part()->created.get();
}

PublTitle *PartBase::getPartPubl() {
	Str s="where oid=";
	oid2str(part()->publno.get(), &s);
	PublTitle *pt=getPublTitles(s);
	if(!pt) throw KaspaErr("Part has no publication!");
	return pt;
}

PartDataName *PartBase::getFiles() {
	Str s="where partdata.partno=";
	oid2str(part()->id.get(), &s);
	return getPartDataNames(s);
}

AuthorName *PartBase::getPartAuthors() {
		Str s("where author.oid=part_author.authorno and part_author.partno=");
  	oid2str(part()->id.get(), &s);
	  return getAuthorNames(s);
}

void PartBase::setTitle(const char *s) {
  part()->title.set(s);
  part()->title.setChanged();
}

void PartBase::setNumber(const char *s) {
  part()->partno.set(s);
  part()->partno.setChanged();
}

void PartBase::setPages(const char *s) {
  part()->pages.set(s);
  part()->pages.setChanged();
}

void PartBase::setLanguage(const char *s) {
  part()->language.set(s);
  part()->language.setChanged();
}

void PartBase::setKey(const char *s) {
  part()->key.set(s);
  part()->key.setChanged();
}

void PartBase::setFirstFile(Oid o) {
  part()->intro.set(o);
  part()->intro.setChanged();
}

void PartBase::setPubl(Oid o) {
  part()->publno.set(o);
  part()->publno.setChanged();
}

void PartBase::setMemo(const char *s) {
  part()->memo.set(s);
  part()->memo.setChanged();
}

void PartBase::setBibTex(const char *bibtex) {
  part()->bibtex.set(bibtex);
  part()->bibtex.setChanged();
}

void PartBase::setCreateBibTex(bool b) {
  part()->createbibtex.set(b);
  part()->createbibtex.setChanged();
}

KaspaRec *PartBase::read(const char *where) {
  return getPart(where);
}

void PartBase::write(const char *where, bool block) {
  updatePart(part(), where, block);
}

KaspaRec *PartBase::invalid() {
  PartRec *part=new PartRec();
  assert(part);
  part->id.set((Oid)InvalidOid);
	return part;
}

void PartBase::del(const Oid o) {
	Str s="where part.oid=";
	oid2str(o, &s);
  deletePart(s);
  part()->id.set((Oid)InvalidOid);
  part()->empty();
}


PartRec *PartBase::part() {
  if(!dynamic_cast<PartRec*>(rec))
    abort();
  return dynamic_cast<PartRec*>(rec);
}


Oid PartBase::createNote() {
	Oid o=newNote(part()->publno.get());
	insertLink(o);
	return o;
}	

Oid PartBase::createAuthor() {
	Oid o=newAuthor();
	newPartAuthor(part()->id.get(), o);
	return o;
}

void PartBase::insertAuthor(Oid o) {
	newPartAuthor(part()->id.get(), o);
}
	
void PartBase::removeAuthor(Oid o) {
	Str s="where authorno=";
	oid2str(o, &s);
	s+=" and partno=";
	oid2str(part()->id.get(), &s);
	deletePartAuthor(s);
}

NoteTitle *PartBase::getNotes() {
	Str s="where publicationno=";
	oid2str(part()->publno.get(), &s);
	s+=" order by title";
	return getNoteTitles(s);
}


void PartBase::deleteFile(Oid o) {
	Str s="where oid=";
	oid2str(o, &s);
	deletePartData(s);

}

void PartBase::deleteFile(const char *name) {
	Str s="where partno=";
	oid2str(id(), &s);
	s+=" and filename='";
	s+=name; s+="'";
	deletePartData(s);
}

/**  */
int PartBase::bibTexIndex(Oid author, const char *year, Oid publ){
	return KaspaBase::bibTexIndex(author, year, publ);
}
