/***************************************************************************
                          settingsdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Apr 22 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>

#include "messenger.h"
#include "settingsdialog.h"

SettingsDialog::SettingsDialog(struct MessengerConfigurator config) :
	QDialog(0, i18n("Application settings"), true)
{
	// just OK and cancel for the moment
	QPushButton *okbutton = new QPushButton(i18n("OK"), this);
	okbutton->setGeometry( 40, 240, 100, 30 );
	okbutton->setMinimumSize( 0, 0 );
	okbutton->setMaximumSize( 32767, 32767 );
	okbutton->setFocusPolicy( QWidget::TabFocus );
	okbutton->setAutoResize( true );
	okbutton->setDefault( true );

	QObject::connect(okbutton,SIGNAL(clicked()), this, SLOT(accept()));

	QPushButton *cancelbutton = new QPushButton(i18n("Cancel"), this);
	cancelbutton->setGeometry( 210, 240, 100, 30 );
	cancelbutton->setMinimumSize( 0, 0 );
	cancelbutton->setMaximumSize( 32767, 32767 );
	cancelbutton->setFocusPolicy( QWidget::TabFocus );
	cancelbutton->setAutoResize( true );
	cancelbutton->setDefault( false );
	
	QObject::connect(cancelbutton,SIGNAL(clicked()), this, SLOT(reject()));
	
	setCaption(i18n("Application Settings"));
	
	QLabel* label_1;
	label_1 = new QLabel( this, "Label_1" );
	label_1->setGeometry( 40, 30, 100, 30 );
	label_1->setMinimumSize( 0, 0 );
	label_1->setMaximumSize( 32767, 32767 );
	label_1->setFocusPolicy( QWidget::NoFocus );
	label_1->setFrameStyle( 0 );
	label_1->setLineWidth( 1 );
	label_1->setMidLineWidth( 0 );
	label_1->QFrame::setMargin( 0 );
	label_1->setText( "Serial Device:" );
	label_1->setAlignment( 289 );
	label_1->setMargin( -1 );

	serialDevice = new QLineEdit( this, "serialDevice" );
	serialDevice->setGeometry( 150, 30, 170, 30 );
	serialDevice->setMinimumSize( 0, 0 );
	serialDevice->setMaximumSize( 32767, 32767 );
	serialDevice->setFocusPolicy( QWidget::StrongFocus );
	serialDevice->setBackgroundMode( QWidget::PaletteBase );
	serialDevice->setFontPropagation( QWidget::NoChildren );
	serialDevice->setPalettePropagation( QWidget::NoChildren );
	serialDevice->setText( config.serialLine );
	serialDevice->setMaxLength( 25 );
	serialDevice->setFrame( QLineEdit::Normal );
	serialDevice->setFrame( true );

	QLabel* label_2;
	label_2 = new QLabel( this, "Label_2" );
	label_2->setGeometry( 40, 90, 100, 30 );
	label_2->setMinimumSize( 0, 0 );
	label_2->setMaximumSize( 32767, 32767 );
	label_2->setFocusPolicy( QWidget::NoFocus );
	label_2->setFrameStyle( 0 );
	label_2->setLineWidth( 1 );
	label_2->setMidLineWidth( 0 );
	label_2->QFrame::setMargin( 0 );
	label_2->setText( "Baudrate:" );
	label_2->setAlignment( 289 );
	label_2->setMargin( -1 );

	baudrate = new QComboBox( FALSE, this, "baudrate" );
	baudrate->setGeometry( 150, 90, 56, 25 );
	baudrate->setMinimumSize( 0, 0 );
	baudrate->setMaximumSize( 32767, 32767 );
	baudrate->setFocusPolicy( QWidget::StrongFocus );
	baudrate->setBackgroundMode( QWidget::PaletteBackground );
	baudrate->setFontPropagation( QWidget::AllChildren );
	baudrate->setPalettePropagation( QWidget::AllChildren );
	baudrate->setSizeLimit( 10 );
	baudrate->setAutoResize( true );
	baudrate->insertItem( "2400" );
	baudrate->insertItem( "4800" );
	baudrate->insertItem( "9600" );
	baudrate->insertItem( "19200" );
	baudrate->insertItem( "38400" );
	baudrate->setMaxCount( 10 );
	baudrate->setAutoCompletion( false );
	
	// set correct item
	int bIdx = 0;
	switch (config.baudrate.toInt())
	{
		case 2400  : bIdx = 0; break;
		case 4800  : bIdx = 1; break;
		case 9600  : bIdx = 2; break;
		case 19200 : bIdx = 3; break;
		case 38400 : bIdx = 4; break;
	}
	baudrate->setCurrentItem(bIdx);

	QLabel* label_3;
	label_3 = new QLabel( this, "Label_3" );
	label_3->setGeometry( 40, 150, 100, 30 );
	label_3->setMinimumSize( 0, 0 );
	label_3->setMaximumSize( 32767, 32767 );
	label_3->setFocusPolicy( QWidget::NoFocus );
	label_3->setFrameStyle( 0 );
	label_3->setLineWidth( 1 );
	label_3->setMidLineWidth( 0 );
	label_3->QFrame::setMargin( 0 );
	label_3->setText( "Faxviewer:" );
	label_3->setAlignment( 289 );
	label_3->setMargin( -1 );

	faxViewer = new QLineEdit( this, "faxViewer" );
	faxViewer->setGeometry( 150, 150, 170, 30 );
	faxViewer->setMinimumSize( 0, 0 );
	faxViewer->setMaximumSize( 32767, 32767 );
	faxViewer->setFocusPolicy( QWidget::StrongFocus );
	faxViewer->setBackgroundMode( QWidget::PaletteBase );
	faxViewer->setFontPropagation( QWidget::NoChildren );
	faxViewer->setPalettePropagation( QWidget::NoChildren );
	faxViewer->setText( config.faxViewer );
	faxViewer->setMaxLength( 25 );
	faxViewer->setFrame( QLineEdit::Normal );
	faxViewer->setFrame( true );

	resize( 350,300 );
	setMinimumSize( 350, 300 );
	setMaximumSize( 350, 300 );
}

SettingsDialog::~SettingsDialog()
{
}
















