/***************************************************************************
                          kweboptions.h  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999 by Troy Ogden
    email                : badger@bookshelves.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEBOPTIONS_H
#define KWEBOPTIONS_H

#include <qdialog.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <qwidget.h>
#include <qstring.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qtabdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <kapp.h>


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
/**
  *@author Troy Ogden
  */
class KWebOptions : public QTabDialog
	{
   Q_OBJECT

public:
	KWebOptions(QWidget* parent=0, const char* name=0);
	~KWebOptions();
	bool isChecked();
	QRadioButton *rb0,*rb1,*rb2,*rb3,*rb4,*rb5,*rb6,*rb7,*rb8;

private:
	QGroupBox 	*box;
	QLineEdit	*ed1,*ed2,*ed3,*ed4,*ed5;

protected:
  	QWidget 	*tab;
	KWebOptions	*optionsDlg;
	QButtonGroup	*btgroup, btgroup2;
	QGridLayout 	*grid;
	QWidget 	*tab2;
	QBoxLayout 	*b;
	QGridLayout 	*my_radioLayout;
	QWidget 	*tab3;	
	QString 	server, _server;
	QString 	username, _username;
	QString 	password, _password;
	QString 	directory, _directory;
	QString 	imgname, _imgname;
	QString		imgdir;
	QString 	delay;
	KConfig 	*config;
	void 		readSettings();

private slots:
	void apply();
	void cancel();
	void radioButtonClicked( int id );	

signals:	
	void cancelButtonPressed();
	void applyButtonPressed();

};

#endif
