    /*

    random.h  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@uwix.alt.na

    The class Random is based on Makoto Matsumoto 's and Takuiji
    Nishimimura's 'mt19937.c'. They invented the algorithm and all
    credits go to them (matumoto@math.keio.ac.jp). All blames for
    bugs on the other hand are earned by me.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef __RANDOM__
#define __RANDOM__


class Random
  {
  public:
    Random( unsigned long seed = 0 );
    ~Random();
    double         drand();
    double         drand( double lowerLimit, double upperLimit );
    unsigned long  lrand();
    unsigned long  lrand( unsigned long lowerLimit, unsigned long upperLimit );
  private:
    unsigned long rand();
    inline unsigned long Random::temperingShiftU( unsigned long y ) 
                                                     { return ( y >> 11 ); }
    inline unsigned long Random::temperingShiftS( unsigned long y )
                                                     { return ( y << 7 ); }
    inline unsigned long Random::temperingShiftT( unsigned long y )
                                                     { return ( y << 15 ); }
    inline unsigned long Random::temperingShiftL( unsigned long y )
                                                     { return ( y >> 18 ); }
    unsigned long *mt;
    unsigned long mag01[2];
    int mti;
  };

#endif  //  __RANDOM__
