    /*

    graph.h  for  KTsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __GRAPH__
#define __GRAPH__


#include <qwidget.h>
#include <qlist.h>



class Graph : public QWidget
  {
  Q_OBJECT

  public:
    Graph( QWidget *parent = 0, const char *name = 0 );
    virtual ~Graph();
    virtual QSize sizeHint() const;
    // clears the display and resets all data
    void clear();
    // sets the vertical scale of the display
    void setVScale( double v );
    // sets the horizontal scale of the display
    void setHScale( int h );
    // returns the number of stored values
    int numberOfValues();
    // returns the first stored value
    double firstValue();
    // returns the next stored value
    double nextValue();

  public slots:
    // the next value to be displayed
    void slotNextValue( double value );

  protected:
    // repaints the whole display
    virtual void paintEvent( QPaintEvent *e );
  private:
    // internal store of the scales
    int hScale;
    double vScale;
    // number of received values
    int receivedValues;
    // storage of all values received so far
    QList<double> values;
  };




#endif   // __GRAPH__
