#ifndef _KEXPLORER_H_
#define _KEXPLORER_H_

#include <config.h>

#include <ktmainwindow.h>
#include <knewpanner.h>
#include <qsplitter.h>
#include <qaccel.h>
#include "ksplitter.h"
#include "mystrlist.h"
#include <qlabel.h>
#include <kapp.h>
#include <device.h>
#include "dirview.h"
#include "kpiconloader.h"
#include "fileinfo.h"
#include "kfixpanner.h"
#include "dircombo.h"
#include "protmgr.h"
#include "kmime.h"
#include "mimemagic.h"
#include "Options.h"
#include "common.h"
#include "preview.h"
#include "history.h"

// Definition of the base application class
class KExplorer : public KTMainWindow
{
	Q_OBJECT;

public:
	KExplorer(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~KExplorer();

	void catchSignal(int sig);
	void initialize(const char *path = 0);

protected:
	void setupMenu();
	void setupToolBar();
	void loadConfiguration();
	void saveConfiguration();
	void loadDevices();
	void saveDevices();
	void setupMimeTypes();
	void saveMimeTypes();
	void scanMimeDir(const QString& dir);
	void scanAppLnkDir(const QString& dir);
	void initBusy();
	void finishBusy();
//	void destroyFileView();
	FileViewWidget* createFileView(int style, QWidget *parent = 0);
	void resortFileList();
	Device* findDevice(const char *name);
	Device* findDevice(Protocol*);
	void executeAction(const char *cmd, KURL& url);
	void removeURLs();
	Device* findTrash();
	void listDevices(FileWindow *wnd, bool local);
	void listDesktop(FileWindow *wnd);
	Protocol* createArchiveProtocol(KURL& url);
	bool goToDir(KURL& url);
	bool createXVPICSDir(KURL& url);
	FileViewWidget* fileView();
	void createWindow(int style);
	FileWindow* currentWindow();
	void updateWindow(FileWindow *wnd, const QString& urlStr);
	void changeView(int newStyle);
	void changeSorting(int newSort);
	void checkUpdateWindow(const char *str1, const char *str2 = 0, const char *treepath = 0);
	void recreateWindows(QWidget *parent, FileWindowList *list, bool limitToOne = FALSE);
//	void changeViewType(int newType, QWidget *parent);
	void showImagePreview(bool show = true);
	void splitWindow(int type);
	void setURLCaption(const char *url);
	void refresh(bool rescan = true);
	void updateTreeView();

	virtual bool queryClose();
	bool eventFilter(QObject *o, QEvent *e);
	void installGlobalFilter(QWidget *w);
	void setGlobalFilter(QWidget *w, bool install = true, QList<QObject> *except = 0);
	void addToHistory(const char *url);
	void constructHistoryMenu();
	void loadBookmarks();
	void saveBookmarks();
	void constructBookmarkMenu();

protected slots:
	void mainCallback();
	void scanDirectory(DirViewItem *item);
	void scanSubDirectories(DirViewItem *item);
	void bigIcons();
	void listIcons();
	void smallIcons();
	void detailIcons();
	void openItem(FileInfo*);
	void columnPressed(int col);		// in detail mode
	void cut();
	void copy();
	void paste();
	void remove();
	void property();
	void newDevice();
	void removeDevice();
	void shutdown();
	void toggleToolBar();
	void toggleViewToolBar();
	void toggleURLToolBar();
	void toggleStatusBar();
	void popupFileView();
	void openThisItem();
	void removeThisDevice();
	void edit();
	void menuActivated(int);
	void popupDirectoryTree(DirViewItem*);
	void explore();
	void expand();
	void collapse();
	void newDir();
	void openTerminal();
	void openWith();
	void launchFind();
	void dropOnTree(QDropEvent *e, DirViewItem *item);
	void dropOnFileView(QDropEvent*, FileInfo*, FileViewWidget*);
	void copyDrag();
	void moveDrag();
	void linkDrag();
	void toggleShowHidden();
	void abort();
	void options();
	void optionsApply();
	void slotRefresh();
	void selectionChanged();
	void renameItem(FileInfo*, const QString&);
	void moveToTrash();
	void emptyTrash();
	void removeThisFolder();
	void propertyThisFolder();
	void updateHasChilds(DirViewItem *item);
	void refreshDir();
	void toggleShowMiniImages();
	void toggleShowArchive();
	void miniImageRequested(FileInfo*);
	void openArchive();
	void selectOutdatedThumbnails();
	void goToDir();
	void windowSelected(KMDIWindow*);
	void windowSelected(FileViewWidget*);
	void windowSelected(FileWindow*);
	void cascade();
	void tile();
	void tileV();
	void tileH();
	void windowRemoved(KMDIWindow*);
	void newWindow();
	void maximize();
	void minimize();
	void restore();
	void wClose();
	void popupMDI();
	void toggleMultipleView();
	void toggleAutoTile();
	void openProtocol();
	void closeProtocol();
	void splitHorizontal();
	void splitVertical();
	void singleView();
	void selectAll();
	void showImagePreviewFullSize();
	void toggleImagePreview();
	void changeDeviceProperties();
	void detailPropertiesChanged();
	void addBookmark();
	void editBookmarks();
	void message1(const char *msg);
	void historyEnterPressed();
	void rescanNetwork();
	void toggleShowTreeView();
	void protocolClosed(Protocol*);
	void startRenaming();
	void formatDevice();

private:
	// Widgets
	KSplitter	*MainView;
//	KFixPanner	*RightView;
	KFixPanner	*LeftView;
	FileViewWidget	*FileView;
	DirView		*DirectoryTree;
	KPIconLoader	*IconLoader;
	int		ToolBarID;
	int		ViewToolBarID;
	int		URLToolBarID;
#define	ToolBar		toolBar(ToolBarID)
#define ViewToolBar	toolBar(ViewToolBarID)
#define	URLToolBar	toolBar(URLToolBarID)
#define	URLCombo	((HistoryCombo*)(toolBar(URLToolBarID)->getWidget(URLLINED_ID)))
	KMenuBar	*MenuBar;
	KStatusBar	*StatusBar;
//	QLabel		*RightViewInfo;
	QLabel		*LeftViewInfo;
	DirCombo	*Combo;
/*	KFileHeader	*FileHeader;*/
	KSplitter	*RightSubView;
	QPopupMenu	*Pop1;
	QPopupMenu	*Pop2;
	QPopupMenu	*Pop3;
	QPopupMenu	*Pop4;
	Options		*OptionsDlg;
	QLabel		*Status1Info;
	QLabel		*Status2Info;
	KMDIMgrBase	*MDIMgr;
	FileWindowList	*WindowList;
	FileWindow	*OldWindow;
	QPopupMenu	*WindowMenu;
	QPopupMenu	*ListMenu;
	QPopupMenu	*HistoryMenu;
	QPopupMenu	*BookmarkMenu;
	KSplitter	*MainRightView;
	PreviewArea	*Preview;

	// Components
	KConfig		*ConfigFile;
	QList<Device>	DeviceList;
	ProtocolMgr	*Manager;
	KMimeExtList	*ExtensionList;
	KMimeAppList	*ApplicationList;
	KMimeExtDict	*ExtensionDict;
	KMimeExtList	*FilenameDict;
	KMimeAppDict	*ApplicationDict;
	MimeMagic	*Magic;
	MyStrList	URLList;
	bool		Cutted;
	DirViewItem	*TmpDevice;
	QString		TmpAddress;
	bool		Busy;
	SubProtList	*ProtList;
	QStrList	HistoryList;
	QList<BookmarkItem>	BookmarkList;
	QAccel			*BookmarkAccel;
	QList<int>		BookmarkToolList;

	// Config elements
	KExplorer_options	*KOptions;
};

inline void KExplorer::explore()
{ DirectoryTree->setCurrentItem(DirectoryTree->popupItem());}

inline void KExplorer::expand()
{ DirectoryTree->expandItem(DirectoryTree->popupItem());}

inline void KExplorer::collapse()
{ DirectoryTree->collapseItem(DirectoryTree->popupItem());}

inline void KExplorer::abort()
{ Manager->abort();}

inline void KExplorer::refreshDir()
{ DirectoryTree->rescanChilds(DirectoryTree->popupItem(),true);}

inline FileViewWidget* KExplorer::fileView()
{ return FileView;}

inline void KExplorer::cascade()
{ if (KOptions->MultipleView) MDIMgr->cascade();}

inline void KExplorer::tile()
{ if (KOptions->MultipleView) MDIMgr->tile();}

inline void KExplorer::tileV()
{ if (KOptions->MultipleView) MDIMgr->tileVertical();}

inline void KExplorer::tileH()
{ if (KOptions->MultipleView) MDIMgr->tileHorizontal();}

inline void KExplorer::maximize()
{ if (KOptions->MultipleView && currentWindow()) currentWindow()->Window->slotMaximize();}

inline void KExplorer::minimize()
{ if (KOptions->MultipleView && currentWindow()) currentWindow()->Window->slotMinimize();}

inline void KExplorer::restore()
{ if (KOptions->MultipleView && currentWindow()) currentWindow()->Window->slotRestore();}

inline void KExplorer::wClose()
{ if (KOptions->MultipleView && currentWindow()) currentWindow()->Window->slotClose();}

inline void KExplorer::selectAll()
{ fileView()->selectAll();}

inline void KExplorer::slotRefresh()
{ refresh();}

#endif
