#include "bookmark.h"
#include <kapp.h>
#include <kaccel.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include "common.h"

#define	KEY_START	Key_0
#define	KEY_STOP	Key_Z

BookmarkEditDialog::BookmarkEditDialog(QWidget *parent, const char *name)
	: QDialog(parent,name,true)
{
	QLabel	*NameLabel = new QLabel(i18n("Name"),this);
	NameLabel->setGeometry(10,10,100,25);
	Name = new QLineEdit(this);
	Name->setGeometry(110,10,200,25);
	QLabel	*BookmarkLabel = new QLabel(i18n("Address"),this);
	BookmarkLabel->setGeometry(10,45,100,25);
	Bookmark = new QLineEdit(this);
	Bookmark->setGeometry(110,45,200,25);
	QLabel	*AccelLabel = new QLabel(i18n("Shortcut"),this);
	AccelLabel->setGeometry(10,80,100,25);
	QLabel	*AccelLabel2 = new QLabel("Ctrl + Shift +",this);
	AccelLabel2->setGeometry(110,80,80,25);
	AccelKey = new QComboBox(this);
	AccelKey->setGeometry(190,80,120,25);
	AccelKey->insertItem("None");
	for (int i=KEY_START;i<=KEY_STOP;i++) AccelKey->insertItem(keyToString(i).data());
	AccelKey->setCurrentItem(0);
	QLabel	*IconLabel = new QLabel(i18n("Icon"),this);
	IconLabel->setGeometry(10,115,100,25);
	Loader = kapp->getIconLoader();
	IconButton = new KIconLoaderButton(Loader,this);
	IconButton->setGeometry(110,115,25,25);
	QLabel	*PositionLabel = new QLabel(i18n("Position"),this);
	PositionLabel->setGeometry(10,150,100,25);
	Position = new QComboBox(this);
	Position->setGeometry(110,150,200,25);
	Position->insertItem(i18n("Menu"));
	Position->insertItem(i18n("Toolbar"));
	Position->insertItem(i18n("Menu & Toolbar"));

	QPushButton	*ok = new QPushButton(i18n("OK"),this);
	ok->setGeometry(10,185,80,30);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	ok->setDefault(true);
	QPushButton	*cancel = new QPushButton(i18n("Cancel"),this);
	cancel->setGeometry(230,185,80,30);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));

	resize(320,225);
	setMaximumSize(320,225);
	setMinimumSize(320,225);
}

BookmarkEditDialog::~BookmarkEditDialog()
{
}

void BookmarkEditDialog::setupDialog(BookmarkItem *item)
{
	Name->setText(item->Name.data());
	Bookmark->setText(item->Bookmark.data());
	AccelKey->setCurrentItem(item->AccelKey ? item->AccelKey-KEY_START+1 : 0);
	IconButton->setIcon(item->IconName.data());
	IconButton->setPixmap(Loader->loadIcon(item->IconName.data()));
	Position->setCurrentItem(item->Status-1);
}

void BookmarkEditDialog::fillItem(BookmarkItem *item)
{
	item->Name = Name->text();
	item->Bookmark = Bookmark->text();
	item->IconName = IconButton->icon();
	item->AccelKey = (AccelKey->currentItem() ? AccelKey->currentItem() + KEY_START - 1 : 0);
	item->Status = Position->currentItem() + 1;
}

//--------------------------------------------------------------------------------------------

BookmarkDialog::BookmarkDialog(QWidget *parent, const char *name)
	: QDialog(parent,name,true)
{
	BookList.setAutoDelete(true);

	List = new QListView(this);
	List->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	List->setAllColumnsShowFocus(true);
	List->setSorting(-1);
	List->addColumn(i18n("Name"));
	List->addColumn(i18n("Accel"));
	List->addColumn(i18n("Address"));
	List->addColumn(i18n("Menu"));
	List->addColumn(i18n("Toolbar"));
	connect(List,SIGNAL(rightButtonPressed(QListViewItem*,const QPoint&,int)),SLOT(slotRightButtonPressed(QListViewItem*,const QPoint&,int)));

	Loader = kapp->getIconLoader();

	ok = new QPushButton(i18n("OK"),this);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	ok->setDefault(true);
	cancel = new QPushButton(i18n("Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));

	setCaption(i18n("Bookmarks"));
	resize(450,250);
}

BookmarkDialog::~BookmarkDialog()
{
}

void BookmarkDialog::resizeEvent(QResizeEvent *e)
{
	List->setGeometry(10,10,width()-20,height()-60);
	ok->setGeometry(10,height()-40,80,30);
	cancel->setGeometry(width()-90,height()-40,80,30);
}

void BookmarkDialog::slotRightButtonPressed(QListViewItem *item, const QPoint& p, int col)
{
	QPopupMenu	pop;
	pop.insertItem(i18n("New"),1);
	pop.insertItem(i18n("Edit"),2);
	pop.insertItem(i18n("Remove"),3);
	if (!List->currentItem()) {
		pop.setItemEnabled(2,false);
		pop.setItemEnabled(3,false);
	}
	int	result = pop.exec(QCursor::pos());
	BookmarkEditDialog	*dlg = new BookmarkEditDialog(this);
	int	index = (List->currentItem() ? List->currentItem()->itemPos()/List->currentItem()->height() : -1);
	switch (result) {
	   case 1:
		if (dlg->exec()) {
			BookmarkItem	*item = new BookmarkItem("");
			dlg->fillItem(item);
			BookList.append(item);
			updateListView();
		}
		break;
	   case 2:
		dlg->setupDialog(BookList.at(index));
		if (dlg->exec()) {
			dlg->fillItem(BookList.at(index));
			updateListView();
		}
		break;
	   case 3:
		BookList.remove(index);
		updateListView();
		break;
	}
	delete dlg;
}

void BookmarkDialog::readBookmarks(QList<BookmarkItem>& bookmarks)
{
	BookList.clear();
	QListIterator<BookmarkItem>	it(bookmarks);
	for (;it.current();++it) BookList.append(new BookmarkItem(*(it.current())));
	updateListView();
}

void BookmarkDialog::writeBookmarks(QList<BookmarkItem>& bookmarks)
{
	bookmarks.clear();
	QListIterator<BookmarkItem>	it(BookList);
	for (;it.current();++it) bookmarks.append(new BookmarkItem(*(it.current())));
}

void BookmarkDialog::updateListView()
{
	QListIterator<BookmarkItem>	it(BookList);
	List->setUpdatesEnabled(false);
	List->clear();
	for (it.toLast();it.current();--it) {
		QListViewItem	*item = new QListViewItem(List,it.current()->Name.data(),(it.current()->AccelKey ? keyToString(it.current()->AccelKey+CTRL+SHIFT).data() : ""),it.current()->Bookmark.data(),(it.current()->Status & BOOKMARK_MENU ? i18n("Yes") : i18n("No")),(it.current()->Status & BOOKMARK_TOOL ? i18n("Yes") : i18n("No")));
		item->setPixmap(0,Loader->reloadIcon(it.current()->IconName));
	}
	List->setUpdatesEnabled(true);
	List->repaint();
}
