/* 
 * key.cpp
 *
 * Copyright (c) 1997 Christian Stueble stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h> 
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include <qlayout.h>
#include <qfiledlg.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qdatetm.h>

#include <kiconloader.h>
#include <kmsgbox.h> 
#include <kapp.h>

#include "key.h"
#include "md5.h"

//  KPGPMPI
KPGPMPI::KPGPMPI()
{		
  bit_len  = 0;
  byte_len = 0;
};

KPGPMPI::~KPGPMPI()
{
  if (bit_len)
    delete [] num;
};

KPGPMPI& KPGPMPI::operator<<(QDataStream &ds)
{
  ds >> bit_len;
  
  byte_len = bit_len / 8;
  
  if (bit_len % 8)
    byte_len++;
  
  num = new UINT8[byte_len];
  
  ds.readRawBytes((char*) num, byte_len);
  
  return *this;
};

UINT32 KPGPMPI::store(UINT8 *dest)
{
  memcpy(dest, num, byte_len);
  
  return byte_len;
};

UINT32 KPGPMPI::bitLen()
{
  return bit_len;
};

UINT32 KPGPMPI::byteLen()
{
  return byte_len;
};

QString KPGPMPI::keyID()
{
  QString id;
	
  id.sprintf(KEYID_FORMAT, num[byte_len-4], num[byte_len-3], num[byte_len-2], num[byte_len-1]);
  
  return id;
}

//  KPGPTrust
KPGPTrust::KPGPTrust(QDataStream &ds)
{
  UINT8  len;
  UINT8  CTB;
  UINT8  len8;
  UINT16 len16;
  UINT32 len32;
  
  ok = FALSE;
  
  ds >> CTB;
  
  // type = trust (12)
  if (((CTB >> 2) & 15) != 12)
    {
      if (CTB != 0xff)
	ds.device()->ungetch(CTB);
    }
  else
    {
      ok = TRUE;
      
      switch (CTB & 3)
	{
          case 0: ds >> len8;   // 1 byte packet len
		  len = len8;
		  break;
          case 1: ds >> len16;  // 2 byte packet len
		  len = len16;
	          break;
          case 2: ds >> len32;  // 4 byte packet len
		  len = len32;
		  break;
          case 3: len = 0;      // unknown packet len
		  break;
	}
      
      ds >> trust;
    }
};

KPGPTrust::~KPGPTrust()
{};
    

UINT8         KPGPTrust::trustByte()
{
  return trust; 
};



// user ID
KPGPUserID::KPGPUserID(QDataStream &ds)
    : KTreeListItem()
{
  UINT8          CTB;
  UINT8          len8;
  UINT16         len16;
  UINT32         len32;
  KPGPSignature  *sig;
  
  ok = FALSE;
  len = 0;
  
  ds >> CTB;
  
  // type = user ID (13)
  if (((CTB >> 2) & 15) != 13)
    {
      if (CTB != 0xff)
	ds.device()->ungetch(CTB);
    }
  else
    {
      ok = TRUE;
      
      switch (CTB & 3)
	{
          case 0: ds >> len8;   // 1 byte packet len
		  len = len8;
		  break;
          case 1: ds >> len16;  // 2 byte packet len
		  len = len16;
	          break;
          case 2: ds >> len32;  // 4 byte packet len
		  len = len32;
		  break;
          case 3: len = 0;      // unknown packet len
		  break;
	}
  
      string = new UINT8[len+1];
      ds.readRawBytes((char*) string, len);
      string[len] = 0;
      
      trust = new KPGPTrust(ds);
      
      sig = new KPGPSignature(ds);
      
      while ((sig->ok) && (!ds.eof()))
	{
	  appendChild(sig);
	  sig = new KPGPSignature(ds);
	}
      
      if (!sig->ok)
	delete sig;
      else
	{
	  appendChild(sig);
	  cout << "signature added " << endl;
	}
      
      setValues();
    }
};
  
KPGPUserID::~KPGPUserID()
{
  if (len)
    delete [] string;
};
    
void KPGPUserID::setValues()
{
  KIconLoader il;
  
  switch (trust->trustByte() & 3)
    {
      case 0:  setPixmap(&il.loadIcon("head_gray.gif"));
	       break;
      case 1:  setPixmap(&il.loadIcon("head_red.gif"));
	       break;
      case 2:  setPixmap(&il.loadIcon("head_yellow.gif"));
	       break;		     
      case 3:  setPixmap(&il.loadIcon("head_green.gif"));  
               break;		     	     
      default: setPixmap(&il.loadIcon("head_gray.gif"));
    }
  
  /*
  QString id;
  id.setStr((char*)string);
  */
  
  setText((char*) string);
}


// KPGPSignature
KPGPSignature::KPGPSignature(QDataStream &ds) 
    : KTreeListItem()
{
  UINT8  len;
  UINT8  CTB;
  UINT8  len8;
  UINT16 len16;
  UINT32 len32;
  
  ok = FALSE;
  
  ds >> CTB;
  
  // type = signature (2)
  if (((CTB >> 2) & 15) != 2)
    {
      if (CTB != 0xff)
	ds.device()->ungetch(CTB);
    }
  else
    {
      ok = TRUE;
      
      switch (CTB & 3)
	{
          case 0: ds >> len8;   // 1 byte packet len
		  len = len8;
		  break;
          case 1: ds >> len16;  // 2 byte packet len
		  len = len16;
	          break;
          case 2: ds >> len32;  // 4 byte packet len
		  len = len32;
		  break;
          case 3: len = 0;      // unknown packet len
		  break;
	}
  
      ds >> version;
      ds >> length;
      ds >> sigType;
      ds >> timestamp;
      ds.readRawBytes((char*)keyId, 8);
      ds >> concAlgo;
      ds >> hashAlgo;
      ds >> testBytes;
  
      digest << ds;
  
      trust = new KPGPTrust(ds);
   
      setValues();
    }
};
  
KPGPSignature::~KPGPSignature()
{};


void KPGPSignature::setValues()
{
  KIconLoader il;
 
  // Set Pixmap
  switch (trust->trustByte() & 7)
    {
      case 2:  setPixmap(&il.loadIcon("feather_red.gif"));
	       break;
      case 5:  setPixmap(&il.loadIcon("feather_yellow.gif"));
	       break;
      case 6:  setPixmap(&il.loadIcon("feather_green.gif"));
	       break;		     
      case 7:  setPixmap(&il.loadIcon("feather_blue.gif"));
               break;		     	     
      default: setPixmap(&il.loadIcon("feather_white.gif"));
    }
  
  keyIdStr.sprintf(KEYID_FORMAT, keyId[4], keyId[5], keyId[6], keyId[7]);
  setText(keyIdStr);
}


// KPGPKey
KPGPKey::KPGPKey(QDataStream &ds)
    : KTreeListItem()
{
  KPGPUserID     *userId;
  UINT8          len;
  UINT8          CTB;
  UINT8          len8;
  UINT16         len16;
  UINT32         len32;
  
  ok = FALSE;
  
  ds >> CTB;
  
  // type = key (6))
  if (((CTB >> 2) & 15) != 6)
    {
      if (CTB != 0xff)
	ds.device()->ungetch(CTB);
    }
  else
    {
      ok = TRUE;
      
      switch (CTB & 3)
	{
          case 0: ds >> len8;   // 1 byte packet len
		  len = len8;
		  break;
          case 1: ds >> len16;  // 2 byte packet len
		  len = len16;
	          break;
          case 2: ds >> len32;  // 4 byte packet len
		  len = len32;
		  break;
          case 3: len = 0;      // unknown packet len
		  break;
	}
  
      ds >> version;
      ds >> timestamp;
      ds >> validity;
      ds >> algo;
  
      n << ds;
      e << ds;
      
      trust = new KPGPTrust(ds);
      
      userId = new KPGPUserID(ds);
      
      while ((userId->ok) && (!ds.eof()))
	{
	  userIdList.append(userId);
	  appendChild(userId);
	  userId = new KPGPUserID(ds);
	}
      
      if (!userId->ok)
	delete userId;
      else
	appendChild(userId);
      
      setValues();
    }
};
  
KPGPKey::~KPGPKey()
{};

QString KPGPKey::fingerPrint()
{
  QString fp1, fp2;
  int      i;
  QString  fp, help;
  MD5      md5;
  UINT8    *DIGEST = new UINT8[16];
  
  UINT32 len = n.byteLen() + e.byteLen();
  UINT8 *BYTES = new UINT8[len];
 
  n.store(BYTES);
  e.store(BYTES + n.byteLen());
  
  md5.hash(BYTES, len, DIGEST);
  
  for (i=0; i<8; i++)
    fp += help.sprintf("%2.2X ", DIGEST[i]);
  fp += "  ";
  for (i=0; i<8; i++)
    fp += help.sprintf("%2.2X ", DIGEST[8+i]);
  
  
  fp1 = fp1.sprintf("%2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X  ", DIGEST[0], DIGEST[1], DIGEST[2], DIGEST[3], DIGEST[4], DIGEST[5], DIGEST[6], DIGEST[7]);
  fp2 = fp2.sprintf("  %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X", DIGEST[8], DIGEST[9], DIGEST[10], DIGEST[11], DIGEST[12], DIGEST[13], DIGEST[14], DIGEST[15]);
  
  delete [] DIGEST;
  delete [] BYTES;
  
  return fp;
};
    

bool   KPGPKey::priv()
{
  return ((trust->trustByte() & 7) == 7);
};
 
QString   KPGPKey::bitlen()
{
  QString str;
  
  return str.sprintf("%d",n.bitLen());
};
 
QString   KPGPKey::created()
{
  QDateTime dt;
  
  dt.setTime_t(timestamp);
  
  return dt.date().toString();
};
 
QString   KPGPKey::keyID()
{
  return n.keyID();
};

QString   KPGPKey::userID()
{
  return childAt(0)->getText();
};

void      KPGPKey::setDefault(bool def)
{
  KIconLoader il;
 
  def_key = def;
  
  if (def_key)
    setPixmap(&il.loadIcon("def_sec_key_blue.gif"));
  else
    setPixmap(&il.loadIcon("sec_key_blue.gif"));
};
    
bool      KPGPKey::getDefault()
{
  return def_key;
};
    
void      KPGPKey::setValues()
{
  KIconLoader il;
  
  // set icon
  if (trust->trustByte() & 32)
    {
      setPixmap(&il.loadIcon("pub_key_paused.gif"));
    }
  else
    {
      switch (trust->trustByte() & 7)
	{
          case 0:  setPixmap(&il.loadIcon("pub_key_gray.gif"));
		   break;
          case 1:  setPixmap(&il.loadIcon("pub_key_gray.gif"));
		   break;
          case 2:  setPixmap(&il.loadIcon("pub_key_red.gif"));
		   break;		     
          case 5:  setPixmap(&il.loadIcon("pub_key_yellow.gif"));
		   break;		     
          case 6:  setPixmap(&il.loadIcon("pub_key_green.gif"));
		   break;		     
          case 7:  setPixmap(&il.loadIcon("sec_key_blue.gif"));
		   break;		     
          default: setPixmap(&il.loadIcon("pub_key_gray.gif"));
	}
    }
    
  // set text
  setText(childAt(0)->getText());
}


// #include "key.moc"