#ifndef _NOTIF_CONFIG_DIALOG_H_
#define _NOTIF_CONFIG_DIALOG_H_

#include <qdialog.h>

class QLineEdit;
class QCheckBox;
class QLabel;
class QGroupBox;
class QPushButton;
class QComboBox;

class CNotifConfigDlg : public QDialog
{
  Q_OBJECT

public:
  CNotifConfigDlg(QWidget* parent, const char* name);
  ~CNotifConfigDlg();

  void writeOptions();

protected:
  QLabel* fStaticAutoLaunch;

  QGroupBox* fBoxSound;
  QGroupBox* fBoxMailReader;

  QCheckBox* fMessage;
  QCheckBox* fShowHeaders;
  QCheckBox* fShowErrors;
  QCheckBox* fShowStatusDlg;
  QCheckBox* fPlaySound;
  QCheckBox* fAutoLaunch;

  QLineEdit* fSoundPath;
  QLineEdit* fAutoLaunchPath;
  QLineEdit* fPlayerPath;

  QPushButton* fSPathBrowse;
  QPushButton* fPPathBrowse;
  QPushButton* fALPathBrowse;
  

public slots:
  void slotSPathBrowseClicked();
  void slotPPathBrowseClicked();
  void slotALPathBrowseClicked();
  void slotPPathBrowseToggled(bool);
};

#endif
