#include "notifconfigdlg.h"

// Standard headers
#include <iostream.h>
#include <stdlib.h>

// KDE headers
#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <klocale.h>

// QT headers
#include <qlineedit.h> 
#include <qcheckbox.h> 
#include <qgroupbox.h>
#include <qlabel.h> 
#include <qpushbutton.h>
#include <qcombobox.h>

CNotifConfigDlg::CNotifConfigDlg(QWidget* parent, const char* name) : QDialog(parent, name)
{
  KConfig* config = kapp->getConfig();

  config->setGroup("NOTIFICATION");

  // -- MESSAGE ON SCREEN ------------------------------------------------
  fMessage = new QCheckBox(i18n("Show New Msg Dialog"), this, "Message");
  fMessage->setGeometry(220, 4, 180, 18);
  fMessage->setChecked(config->readBoolEntry("ShowMessage", FALSE));

  // -- SHOW HEADERS ----------------------------------------------------
  fShowHeaders = new QCheckBox(i18n("Show Headers"), this, "ShowHeaders");
  fShowHeaders->setGeometry(25, 22, 120, 18);
  fShowHeaders->setChecked(config->readBoolEntry("ShowHeaders", FALSE));

  // -- SHOW ERRORS ----------------------------------------------------
  fShowErrors = new QCheckBox(i18n("Show Errors"), this, "ShowErrors");
  fShowErrors->setGeometry(25, 4, 120, 18);
  fShowErrors->setChecked(config->readBoolEntry("ShowErrors", FALSE));
 
  // -- STATUS DIALOG --------------------------------------------------
  fShowStatusDlg = new QCheckBox(i18n("Show Status Dialog"), this, "ShowStatusDlg");
  fShowStatusDlg->setGeometry(220, 22, 180, 18);
  fShowStatusDlg->setChecked(config->readBoolEntry("ShowStatusDlg", TRUE));

  // -- BOX SOUND -----------------------------------------------------
  fBoxSound = new QGroupBox(i18n("Sound"), this, "BoxSound");
  fBoxSound->setGeometry(5, 40, 422, 68);
 
  //-- PLAY SOUND -----------------------------------------------------
  fPlaySound = new QCheckBox(i18n("Play Sound using:"), this, "PlaySound");
  fPlaySound->setGeometry(10, 55, 130, 20);
  //fPlaySound->setChecked(config->readBoolEntry("PlaySound", FALSE));
  connect(fPlaySound, SIGNAL( toggled(bool) ), this, SLOT( slotPPathBrowseToggled(bool) ));
  
  //-- PLAYER PATH ----------------------------------------------------
  fPlayerPath = new QLineEdit(this, "PlayerPath");
  fPlayerPath->setGeometry(140, 55, 220, 20);
  fPlayerPath->setText(config->readEntry("PlayerPath", "kplayaudio"));
  
  //-- SOUND PATH BROWSE ---------------------------------------------
  fPPathBrowse = new QPushButton(i18n("Browse..."), this, "PPathBrowse");
  fPPathBrowse->setGeometry(365, 53, 57, 22);
  connect(fPPathBrowse, SIGNAL( clicked() ), this, SLOT( slotPPathBrowseClicked() ));

  //-- SOUND PATH ----------------------------------------------------
  fSoundPath = new QLineEdit(this, "SoundPath");
  fSoundPath->setGeometry(10, 80, 350, 20);
  fSoundPath->setText(config->readEntry("SoundPath", "mail.wav"));

  //-- SOUND PATH BROWSE ---------------------------------------------
  fSPathBrowse = new QPushButton(i18n("Browse..."), this, "SPathBrowse");
  fSPathBrowse->setGeometry(365, 78, 57, 22);
  connect(fSPathBrowse, SIGNAL( clicked() ), this, SLOT( slotSPathBrowseClicked() ));

  //-- BOX MAIL READER ------------------------------------------------
  fBoxMailReader = new QGroupBox(i18n("Mail Reader"), this, "BoxMailReader");
  fBoxMailReader->setGeometry(5, 109, 422, 62);

  //-- AUTO LAUNCH ---------------------------------------------------
  fAutoLaunch = new QCheckBox(this, "AutoLaunch");
  fAutoLaunch->setGeometry(10, 124, 10, 15);
  fAutoLaunch->setChecked(config->readBoolEntry("AutoLaunch", FALSE));

  //-- STATIC AUTO LAUNCH -------------------------------------------
  fStaticAutoLaunch = new QLabel(i18n("Automatic Launch"), this, "StaticAutoLaunch");
  fStaticAutoLaunch->setGeometry(25, 124, 120, 15);

  //-- AUTO LAUNCH PATH --------------------------------------------
  fAutoLaunchPath = new QLineEdit(this, "AutoLaunchPath");
  fAutoLaunchPath->setGeometry(10, 144, 350, 20);
  fAutoLaunchPath->setText(config->readEntry("AutoLaunchPath", "kmail"));

  //-- SOUND PATH BROWSE ---------------------------------------------
  fALPathBrowse = new QPushButton(i18n("Browse..."), this, "ALPathBrowse");
  fALPathBrowse->setGeometry(365, 142, 57, 22);
  connect(fALPathBrowse, SIGNAL( clicked() ), this, SLOT( slotALPathBrowseClicked() ));

  // Do this again to make sure everythign is on or off as needed
  fPlaySound->setChecked(config->readBoolEntry("PlaySound", FALSE));
  slotPPathBrowseToggled(fPlaySound->isChecked());
}


CNotifConfigDlg::~CNotifConfigDlg()
{
  delete (fStaticAutoLaunch);
  
  delete (fBoxSound);
  delete (fBoxMailReader);

  delete (fMessage);
  delete (fShowHeaders);
  delete (fShowErrors);
  delete (fPlaySound);
  delete (fAutoLaunch);

  delete (fSoundPath);
  delete (fAutoLaunchPath);
}

void CNotifConfigDlg::writeOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("NOTIFICATION");
  
  config->writeEntry("ShowMessage", fMessage->isChecked());
  config->writeEntry("ShowHeaders", fShowHeaders->isChecked());
  config->writeEntry("ShowErrors", fShowErrors->isChecked());
  config->writeEntry("ShowStatusDlg", fShowStatusDlg->isChecked());
  config->writeEntry("PlaySound", fPlaySound->isChecked());
  config->writeEntry("AutoLaunch", fAutoLaunch->isChecked());
  config->writeEntry("PlayerPath", fPlayerPath->text());
  config->writeEntry("SoundPath", (char*)fSoundPath->text());
  config->writeEntry("AutoLaunchPath", (char*)fAutoLaunchPath->text());
  
}

void CNotifConfigDlg::slotSPathBrowseClicked()
{
  QString path;

  path = KFileDialog::getOpenFileName(getenv("HOME"), "*", this, "FileDialog");

  if (!path.isEmpty())
    fSoundPath->setText(path);
}

void CNotifConfigDlg::slotALPathBrowseClicked()
{
  QString path;

  path = KFileDialog::getOpenFileName(getenv("HOME"), "*", this, "FileDialog");

  if (!path.isEmpty())
    fAutoLaunchPath->setText(path);
}

void CNotifConfigDlg::slotPPathBrowseClicked()
{
  QString path;
  
  path = KFileDialog::getOpenFileName(getenv("HOME"), "*", this, "FileDialog");
  
  if (!path.isEmpty())
    fPlayerPath->setText(path);
}

void CNotifConfigDlg::slotPPathBrowseToggled(bool on)
{
  fPPathBrowse->setEnabled(on);
  fSPathBrowse->setEnabled(on);
  fSoundPath->setEnabled(on);
  fPlayerPath->setEnabled(on);
}



#include "notifconfigdlg.moc"
