#include "mailboxconfigdlg.h"
#include "adddialog.h"
#include "resource.h"

#include <kapp.h>
#include <klocale.h>

#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h> 
#include <qcheckbox.h>
#include <qspinbox.h>

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

CMailBoxConfigDlg::CMailBoxConfigDlg(QList<ServerStruct>* mailboxList, QWidget* parent, const char* name) : QDialog(parent, name, FALSE)
{
  fMailboxList = mailboxList;

  fAdd = new QPushButton("Add", this);
  fAdd->setGeometry(330, 8, 50, 20);
  fAdd->setText(i18n("Add"));
  connect(fAdd, SIGNAL(clicked()), this, SLOT(slotAdd()));

  fDelete = new QPushButton("Delete", this);
  fDelete->setGeometry(380, 8, 50, 20);
  fDelete->setText(i18n("Delete"));
  connect(fDelete, SIGNAL(clicked()), this, SLOT(slotDelete()));

  fStaticServer = new QLabel(i18n("Server: "), this, "StaticServer");
  fStaticServer->setGeometry(10, 8, 60, 21);

  fServer = new QComboBox(this, "Server");
  fServer->setGeometry(70, 8, 250, 21);
  //fServer->setInsertionPolicy(QComboBox::AtTop);
  connect (fServer, SIGNAL(activated(int)), this, SLOT(slotComboActivated(int)));

  fInfoBox = new QGroupBox(i18n("Mailbox Information"), this, "InfoBox");
  fInfoBox->setGeometry(5, 35, 400, 135);

  fStaticUserName = new QLabel(i18n("Username: "), this, "StaticUserName");
  fStaticUserName->setGeometry(20, 55, 60, 20);
  
  fUserName = new QLineEdit(this, "UserName");
  fUserName->setGeometry(80, 55, 300, 20);

  fStaticPassword = new QLabel(i18n("Password: "), this, "StaticPassword");
  fStaticPassword->setGeometry(20, 80, 60, 20);
  
  fPassword = new QLineEdit(this, "Password");
  fPassword->setGeometry(80, 80, 300, 20);
  fPassword->setEchoMode(QLineEdit::Password);

  QLabel* label = new QLabel(i18n("Folder: "), this, "FolderLabel");
  label->setGeometry(20, 105, 60, 20);

  fFolder = new QLineEdit(this, "Folder");
  fFolder->setGeometry(80, 105, 140, 20);

  fServerType = new QComboBox(this, "ServerType");
  fServerType->setGeometry(260, 105, 120, 20);
  fServerType->insertItem("Pop3", ServerTypePop3);
  fServerType->insertItem("IMAP", ServerTypeImap);
  fServerType->insertItem("Local (file)", ServerTypeLocal);
  connect (fServerType, SIGNAL(activated(int)), this, SLOT(slotServerTypeChanged(int)));
   

  fStaticPort = new QLabel(i18n("Port: "), this, "StaticPort");
  fStaticPort->setGeometry(20, 130, 60, 20);
  
  fPort = new QSpinBox(1, 2500, 10, this, "Port");
  fPort->setGeometry(80, 130, 70, 20);

  fStaticSavePassword = new QLabel(i18n("Save Password"), this, "StaticSavePassword");
  fStaticSavePassword->setGeometry(190, 130, 100, 20);

  fSavePassword = new QCheckBox(this, "SavePassword");
  fSavePassword->setGeometry(170, 130, 20, 20);

  // setup the combo box with the list of mailboxes.
  ServerStruct *serverInfo;
  serverInfo = fMailboxList->first();
  while (serverInfo != NULL)
    {
      fServer->insertItem(serverInfo->address);
      serverInfo = fMailboxList->next();
    }

  serverInfo = fMailboxList->last();
  setGui(serverInfo, fMailboxList->count() - 1);

}

CMailBoxConfigDlg::~CMailBoxConfigDlg()
{
  delete (fSavePassword);
  delete (fStaticSavePassword);
  delete (fPort);
  delete (fStaticPort);
  delete (fPassword);
  delete (fStaticPassword);
  delete (fUserName);
  delete (fStaticUserName);
  delete (fInfoBox);
  delete (fServer);
  delete (fStaticServer);
  delete (fDelete);
  delete (fAdd);
}


void CMailBoxConfigDlg::slotAdd()
{
  QString address;
  ServerStruct* serverInfo;

  fAddDialog = new CAddDialog(this, "AddDialog");
  fAddDialog->setGeometry(250, 250, 200, 110);
  
  if (fAddDialog->exec())
    {
      address = fAddDialog->ServerName();
      if (!address.isEmpty() )
	{
	  if (fMailboxList->count() == 0)
	    fServer->clear();

	  else
	    writeServerInfo(fServer->currentItem());

	  serverInfo = new ServerStruct;
	  serverInfo->index = 0;
	  serverInfo->address = address;
	  serverInfo->username = "";
	  serverInfo->password = "";
	  serverInfo->folder = "INBOX";
	  serverInfo->port = 110;
	  serverInfo->save = 1;
	  serverInfo->type = ServerTypePop3;
	
	  fMailboxList->append(serverInfo);
	  fServer->insertItem(serverInfo->address);

	  setGui(serverInfo, fMailboxList->count() - 1);
	}
    }

  delete(fAddDialog);
}

void CMailBoxConfigDlg::writeServerInfo(int index)
{
  // Check if there is anything to write
  if (fMailboxList->count() == 0)
    return;

  if (index == -1)
    {
      fServerInfo->username = fUserName->text();
      fServerInfo->password = fPassword->text();
      fServerInfo->folder = fFolder->text();
      fServerInfo->port = fPort->value();
      fServerInfo->save = fSavePassword->isChecked();
      fServerInfo->type = (eServerType)fServerType->currentItem();
    }

  else
    { 
      ServerStruct *serverInfo = fMailboxList->at(index);
      
      serverInfo->username = fUserName->text();
      serverInfo->password = fPassword->text();
      serverInfo->folder = fFolder->text();
      serverInfo->port = fPort->value();
      serverInfo->save = fSavePassword->isChecked();
      serverInfo->type = (eServerType)fServerType->currentItem();
    }

}

void CMailBoxConfigDlg::disableButtons()
{
  fPassword->setEnabled( false );
  fUserName->setEnabled( false );
  fPort->setEnabled( false );
  fSavePassword->setEnabled( false );
  fDelete->setEnabled( false );
  fFolder->setEnabled( false );
  fServerType->setEnabled( false );

  // Empty the fields
  fPassword->setText("");
  fUserName->setText("");
  fFolder->setText("");
  fPort->setValue(0);
  fSavePassword->setChecked(FALSE);
}

void CMailBoxConfigDlg::enableButtons()
{
  fPassword->setEnabled( TRUE );
  fUserName->setEnabled( TRUE );
  fPort->setEnabled( TRUE );
  fSavePassword->setEnabled( TRUE );
  fDelete->setEnabled( TRUE );
  fFolder->setEnabled( true );
  fServerType->setEnabled( true );

}

void CMailBoxConfigDlg::slotDelete()
{
  ServerStruct* serverInfo;

  // Remove from mailbox list
  fMailboxList->remove(fServer->currentItem());

  // Remove from Server combobox
  fServer->removeItem(fServer->currentItem());

  serverInfo = fMailboxList->last();
  setGui(serverInfo, fMailboxList->count() - 1);

}

void CMailBoxConfigDlg::setGui(ServerStruct *serverInfo, int index)
{
  //cout << "Setting gui for " << serverInfo->index << endl;;

  if (serverInfo == NULL)
    disableButtons();

  else
    {
      enableButtons();

      fServer->setCurrentItem(index);

      // Set the gui to the proper values
      fPassword->setText(serverInfo->password);
      fUserName->setText(serverInfo->username);
      fFolder->setText(serverInfo->folder);
      fPort->setValue(serverInfo->port);
      fSavePassword->setChecked(serverInfo->save);
      fServerType->setCurrentItem(serverInfo->type);

      slotServerTypeChanged(serverInfo->type);

      fServerInfo = serverInfo;
    }
}

void CMailBoxConfigDlg::slotComboActivated(int index)
{
  ServerStruct *serverInfo;

   if (fMailboxList->count() == 0)
     setGui(NULL);

   else
    {
      writeServerInfo();

      serverInfo = fMailboxList->at(index);
      setGui(serverInfo, index);
    }
}

void CMailBoxConfigDlg::slotAddDialogOk()
{
  cout << "Adding server " << fAddDialog->ServerName() << endl;
} 

void CMailBoxConfigDlg::writeOptions()
{
  //cout << "Writing current server info" << endl;

  writeServerInfo(fServer->currentItem());
  
  //cout << fMailboxList->count() << endl;
  // The app will handle writing or realoading the list if needed.
}


void CMailBoxConfigDlg::slotServerTypeChanged(int id)
{
  // We need to see what items should be enabled with this server type
  switch (id)
    {
    case ServerTypeLocal:
      fPort->setEnabled( false );
      fPassword->setEnabled( false );
      fSavePassword->setEnabled( false );
      fFolder->setEnabled( false );
      break;
      
    case ServerTypePop3:
      fPort->setEnabled( true );
      fPassword->setEnabled( true );
      fSavePassword->setEnabled( true );
      fFolder->setEnabled( false );
      fPort->setValue(110);
      break;
      
    case ServerTypeImap:
      fPort->setEnabled( true );
      fPassword->setEnabled( true );
      fSavePassword->setEnabled( true );
      fFolder->setEnabled( true );
      fPort->setValue(143);
      break;
    }
}

#include "mailboxconfigdlg.moc"
