
// Standard headers
#include <iostream.h>

// QT headers
#include <qsize.h>
#include <qpopupmenu.h>

// KDE headers
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

// Homemade headers
#include "listview.h"
#include "resource.h"

CListView::CListView(QWidget* parent, const char* name) : QListView(parent, name)
{
  KConfig* config = kapp->getConfig();
  int toColSize, fromColSize;

  config->setGroup("VIEW");

  toColSize = config->readNumEntry("ToColSize", 90);
  fromColSize = config->readNumEntry("FromColSize", 90);
  
  if (config->readNumEntry("ToFieldType", TO_TYPE_ADDRESS) != TO_TYPE_DISABLED)
    {
      addColumn(i18n("To:"), toColSize);  
      addColumn(i18n("From:"), fromColSize);
      addColumn(i18n("Subject:"), parent->width() - (columnWidth(0) + columnWidth(1) + 18));

      setColumnWidthMode(0, QListView::Manual);
      setColumnWidthMode(1, QListView::Manual);
      setColumnWidthMode(2, QListView::Manual);
    }

  else
    {
      addColumn(i18n("From:"), fromColSize);
      addColumn(i18n("Subject:"), parent->width() - (columnWidth(0) + 18));

      setColumnWidthMode(0, QListView::Manual);
      setColumnWidthMode(1, QListView::Manual);
    }
  
}

CListView::~CListView()
{
  
}

void CListView::setSize(int width, int height)
{
  KConfig* config = kapp->getConfig();

  // set the size of the entire view.
  setGeometry(0, 0, width, height);
  
  config->setGroup("VIEW");
   
  if (config->readNumEntry("ToFieldType", TO_TYPE_ADDRESS) != TO_TYPE_DISABLED)
    {
      setColumnWidth(2, width - (columnWidth(0) + columnWidth(1) + 18));
    }

  else
    {
      setColumnWidth(1, width - (columnWidth(0) + 18));
    }
}


void CListView::saveOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("VIEW");

  if (config->readNumEntry("ToFieldType", TO_TYPE_ADDRESS) != TO_TYPE_DISABLED)
    {
      config->writeEntry("ToColSize", columnWidth(0));
      config->writeEntry("FromColSize", columnWidth(1));
    }
  
  else
    {
      config->writeEntry("FromColSize", columnWidth(0));
    }
      
  
}

#include "listview.moc"
