#ifndef KNEWMAILVIEW_H
#define KNEWMAILVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>

#include <qwidget.h>
#include <qlist.h>
#include <qpoint.h>
#include <qlistview.h>

#include "resource.h"

class CListView;
class QMouseEvent;
/**
 * This class provides an incomplete base for your application view. 
 * This also requires a new implementation of resizeEvent so your view is
 * displayed correctly.  Your View Widget should provide methods to handle
 * the users actions on the view and interact with the doc class of the
 * application to set the modified flag for the document. 
 * Example:  You decided to use a QMultilineEdit widget in your view. This
 * Widget emits a signal textChaged() if the user changes the text. Then, you
 * could use this signal to connect to the slot of the doc class to set the
 * modified flag (which then enables the save and save as items.   
 *
 * @author Mike Pilone
 */ 
class KNewMailView : public QWidget
{
  Q_OBJECT

public:
   /** Constructor for the main view */
  KNewMailView(QWidget *parent = 0, const char *name = 0);
  /** Destructor for the main view */
  virtual ~KNewMailView();

  /** Saves any options having to do with the view.
   */
  void saveOptions();

  /** Deletes and the recreates the list view widget.
   */
  void refresh();

  /** Scans through the headerlist and writes the entries to the list view
   */
  void displayHeaderList(QList<HeaderStruct>* headerList);

protected:
  /** resizeEvent for the main view */
  virtual void resizeEvent(QResizeEvent *evt);

  /** Creates the actual listview widget. This method assumes that
   * the listview variable is null or not created.
   */
  void createListViewWidget();


private:
  CListView* fListView;

public slots:
  /** Should be triggered whenever the right mouse button is clicked in the list view.
   * this is used to display the popup menu to toggle the menubar on.
   */
  void slotRightButtonClicked(QListViewItem*, const QPoint&, int);

  /** Should cathc when the left mouse button is double clicked on the list view
   */
   void slotLeftButtonDoubleClicked(QListViewItem*);

signals:
  /** emitted when the right mouse click is detected from the list view
   */
  void rightButtonClicked(const QPoint&);

  /** emitted when the list view is double clicked
   */
  void leftButtonDoubleClicked();

};

#endif // KNEWMAILVIEW_H 
