#ifndef KNEWMAILAPP_H 
#define KNEWMAILAPP_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktmainwindow.h>
#include <ktoolbar.h>

#include <qpoint.h>
#include <qrect.h>
#include <qlist.h>
#include <qstring.h>

#include "resource.h"

class QLabel;
class QPopupMenu;

class KStatusBar;
class KMenuBar;
class KConfig;
class KAccel;

class KNewMailView;
class KNewMailEngine;
class CConfigDialog;
class DockWidget;
class CPassDialog;

/** This is the base class for KNewMail. This class will create the
 * main window, then create a view (knewmailview), all the toolbars 
 * and statusbars, ect. Most of the signals will want to come back
 * to this class so they can be directed where they need to go.
 *
 * @author Mike Pilone 
 */
class KNewMailApp : public KTMainWindow
{
  Q_OBJECT
public:
  /** Constructor 
   */
  KNewMailApp(int noSplash = 0, int upgrade = 0);
  /** Destructor
   */
  virtual ~KNewMailApp();

  /** Gets the password from the user and returns whatever they enter. 
   * If the user enters nothing, an empty string WILL be returned.
   */
  static QString showPassDialog(QString address);

  /** This is just an overload of the KTMainWindows show() function. This
   * is needed because when the application is restored it will attempt
   * to show itself, but if the sessionConfig says it should be docked, we
   * need to ignore the show call.
   */
  void show();

protected:
  /** Initializes all the gui items, such as toolbars,
   * menubars, status bars. Should be called from the 
   * constructor of this class.
   */
  void init();

  /** Creates the toolbar
   */
  void initToolBar();

  /** Creates the statusbar
   */
  void initStatusBar();

  /** Creates the menubar
   */
  void initMenu();

  /** Creates the view and sets the size of the main window. 
   * Basically handles setting everthing the user can see.
   */
  void initView();

  /** Creates the KNewMailEngine.
   */
  void initEngine();

  /** Writes the current information about the window to the
   * config, such as size, ect.
   */
  void saveOptions();

  /** reads the current information about the window from the
   * config, such as size, ect.
   */
  void readOptions();

  /** Cathces resize events and updates the rect variable, then
   * calls th base classes resizeEvent as well as the views resize.
   */
  void resizeEvent(QResizeEvent *evt);

  /** Asks the user if they are sure that they wa to quit.
   * returns true if they want to, false otherwise.
   */
  bool queryExit();

  /** Sets the toolbar to the proper position and 
   * sets if it is visible or not. 
   */
  void setToolBarState(int position, bool visible = TRUE);

  /** Sets the statusbar to the proper position and 
   * sets if it is visible or not. 
   */
  void setStatusBarState(bool visible = TRUE);

  /** Processes the mailbox list. The parameter should be
   * one of the defines in resource.h
   */
  void processMailboxList(int command);
  char* ed(const char* p, const int s, int e);

  /** Overloaded functions which will be called whenever this application
   * is restored by the session manager.
   */
  void readProperties(KConfig*);

  /** Overloaded functions which will be called whenever this application
   * is closed by the session manager (logout).
   */
  void saveProperties(KConfig*);

public slots:

  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);

  /** Called when the user presses ok or apply in the config dialog.
   */
  void slotConfigDlgApply();

  /** Called when the user presses cancel in the config dialog.
   */
  void slotConfigDlgCancel();
  
  /** This should be connected to the engine to be triggered whenever
   * a check is performed.
   */
  void slotCheckPerformed(QList<HeaderStruct> *headerList, QList<HeaderStruct> *newMsgHeaderList);

  /** displays a popup menu at QPoint
   */
  void slotRightButtonClicked(const QPoint&);

  /** Launches the mail app
   */
  void slotLeftButtonDoubleClicked();
  /** Tells the application to doc.
   */
  void slotDock();
  
private:
  /** This is the view of the main window and will be set using the
   * this->set view() method call. */ 
  KNewMailView *fView;
  /** This will be the main engine of the application; it will handle
   * checking the pop3 servers and emitting the mailchecked signal. */
  KNewMailEngine *fEngine;
  /** This is the tabbed configuration dialog; this dialog will create
   * all of the sub-dialogs as individual tabs. */
  CConfigDialog *fConfigDialog;

  KToolBar *fToolBar;
  KStatusBar *fStatusBar;
  KMenuBar *fMenuBar;
  
  QPopupMenu *fFilePopMenu;
  QPopupMenu *fHelpPopMenu;
  /** This menu will be inserted into fMenuBar and also be used as the
   * rightClick PopUpMenu in the list view. */ 
  QPopupMenu *fOptionsPopMenu;
  QPopupMenu *fCommandsPopMenu;

  /** This label will display the splashLogo for a set period of time. */
  QLabel *fSplashLabel;

  /** This timer keeps track of how long the splashLogo is visible. */
  QTimer *fSplashTimer;
  
  /** This holds whether the toolbar is visible or not. */
  bool fViewToolBar;
  /** This holds whether the statusbar is visible or not. */
  bool fViewStatusBar;
  /** Holds the current toolbar position; the value it holds can be translated
   * using the enum from KToolBar. */
  int fToolBarPos;

  /** This boolean variable holds the value of whether the next call to
   * the show method should be passed to the base class KTMainWindow. */
  bool fIgnoreShowCommand;
  /** Holds true if checkMail() was called in the engine. */
  bool fCheckingNow;

   /** fMainGeom keeps the acutal size of your application and is used to
      * restore your last used application size. */
  QRect fMainGeomRect;

  /** list of all the mailboxes
   */
  QList<ServerStruct> fMailboxList;

  /** This is the widget that will plant itself in the panel and wait to be
   * activated by being clicked on or this class calling a dock call.
   *
   * NOTE: This widget was originally written by the author of Kget, It has
   * since been modified to fit my needs.
   */
  DockWidget* fDockWidget;

  /** Keeps track of the last number of messages to be processesd. This is how
   * knewmail knows when new mail has arrived.
   */
  int fNumMessages;

  /** The password dialog. This dialog will be created and displayed whenever the
   * user has selewcted their password not to be saved.
   */
  CPassDialog *fPassDialog;

  KAccel* fKAccel;
  
public slots:
    /** Launches specified application, usually a mail reader.
   */
  void slotLaunchApp();
  /** Toggles program active/inactive
   */
  void slotToggleActive();
    /**Triggers a force mail check
   */
  void slotForceCheck();
  /** Called when the application needs to exit
   */
  void slotAppExit();

protected slots:
  /** Toggles Menubar on/off
   */
  void slotToggleMenuBar();
  /** Opens the config dialog. This stops the whole program
   */
  void slotConfig();
  /** plays the sound specified in the config file.
   */
  void slotPlaySound();
  /** compiles the list of 'from' fields and uses a KMsgBox to display them to the user
   */
  void slotShowMessage(QList<HeaderStruct>* newMsgHeaderList);
  /** Connected to the signal moved from the toolbar. Used to
   * update the position of the toolbar.
   */
  void slotToolBarMoved();

  /** Displays the splash screen and sets itself up as the slot for the
   * splash timer.
   */
  void slotDisplaySplash();

signals:
 
};



#endif // KNEWMAILAPP_H 
