/*
	This code was originally taken from the KGet application. It has been
   modified by Mike Pilone to work in the KNewMail program.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>

#include <qpopupmenu.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlist.h>
#include <qwidget.h>

class QTimer;

class DockWidget : public QWidget 
{

  Q_OBJECT

public:
  DockWidget(QWidget *parent, const char *name=0);
  ~DockWidget();
  
  /** Call this function to hide the main app and put it in the panel.
   */
  void dock();
  
  /** Call this method to restore the window.
   */
  void undock();
  
  /** Sets the icon to be a still icon.
   */
  void setIconNormal();
  
  /** Set ths icon rotating. It also starts the timer so the icon will be updated
   * to make it appear as though the series of icons are animated
   */
  void setIconAnimated();
  
  /** Loads all the icons into a list.
   */
  void setupAnimIcon();

protected:
  QTimer *fTimer;

private slots:
  void toggle_window_state();
  void mousePressEvent(QMouseEvent *e);
  void paintEvent(QPaintEvent *);

public slots:
  void setupDock();
  void slotTimerDone();

public:
  const bool isDocked();

private:
  bool docked;
  int toggleID;

  QList<QPixmap> fAnimIcon;

  QPixmap *fIcon;
  
  QWidget* fParent;
  
  QPopupMenu *popup_m;
};

#endif
