/**********************************************************************

	--- Qt Architect generated file ---

	File: KConf.cpp
	Last generated: Tue Jun 1 16:01:08 1999

 *********************************************************************/

#include "kconf.h"

#define Inherited KConfData

KConf::KConf(QWidget* parent, KnetdumpDoc* doc=0, const char* name):Inherited( parent, name ), pdoc(doc) {
    QString port;
    setCaption( i18n("Configuration & Filter") );
    actualSize=pdoc->getNodeNum();
    portV= new portValidator();
    ipV= new IPValidator();
    port.sprintf("%i",pdoc->recPort);
    LineEdit_Port->setText(port);
    LineEdit_Port->setValidator(portV);
    LineEdit_1->setValidator(ipV);
    LineEdit_2->setValidator(ipV);
    LineEdit_3->setValidator(ipV);
    LineEdit_4->setValidator(ipV);
    updateTime->setValue(pdoc->getUpdateTime()/1000);
    inactiveTime->setValue(pdoc->getInactiveTime()/1000);
    numPackets->setValue(pdoc->getPacketMax());
    promisc->setChecked(pdoc->getPromisc());
    ieee802->setChecked(pdoc->recIEEE802);
    arp->setChecked(pdoc->recARP);
    ip->setChecked(pdoc->recIP);
    tcp->setChecked(pdoc->recTCP);
    udp->setChecked(pdoc->recUDP);
    icmp->setChecked(pdoc->recICMP);
    x->setChecked(pdoc->recX);
    addrSelect->setChecked(pdoc->isNodeSelected());
    resolveName->setChecked(pdoc->isHostResolved());
    asciiOutput->setChecked(pdoc->isasciiOutput());

    if (pdoc->devIsPresent("eth0")) {
        eth0->setEnabled(true);
        eth0->setChecked(pdoc->getInterfaces("eth0"));
    }
    else {
        eth0->setEnabled(false);
	eth0->setChecked(false);
    }
 
   if (pdoc->devIsPresent("eth1")) {
        eth1->setEnabled(true);
        eth1->setChecked(pdoc->getInterfaces("eth1"));
    }
    else {
        eth1->setEnabled(false);
	eth1->setChecked(false);
    }

    if (pdoc->devIsPresent("ppp0")) {
        ppp0->setEnabled(true);
        ppp0->setChecked(pdoc->getInterfaces("ppp0"));
    }
    else {
        ppp0->setEnabled(false);
	ppp0->setChecked(false);
    }

    if (pdoc->devIsPresent("tr0")) {
      tr0->setEnabled(true);
      tr0->setChecked(pdoc->getInterfaces("tr0"));
    }
    else {
        tr0->setEnabled(false);
	tr0->setChecked(false);
    }

    if (pdoc->devIsPresent("slip0")) {
      slip0->setEnabled(true);
      slip0->setChecked(pdoc->getInterfaces("slip0"));
    }
    else {
        slip0->setEnabled(false);
	slip0->setChecked(false);
    }

    if (pdoc->devIsPresent("lo")) {
        lo->setEnabled(true);
        lo->setChecked(pdoc->getInterfaces("lo"));
    }
    else {
        lo->setEnabled(false);
	lo->setChecked(false);
    }
	
    setAddrBox();
}

KConf::~KConf(){
    delete (portV);
    delete (ipV);
}

void KConf::setInterface() {
    pdoc->resetInterfaces();

    if (eth0->isChecked())
        pdoc->activeInterfaces("eth0");
    if (eth1->isChecked())
        pdoc->activeInterfaces("eth1");
    if (ppp0->isChecked())
        pdoc->activeInterfaces("ppp0");
    if (slip0->isChecked())
        pdoc->activeInterfaces("slip0");
    if (tr0->isChecked())
        pdoc->activeInterfaces("tr0");
    if (lo->isChecked())
        pdoc->activeInterfaces("lo");
}

void KConf::setPromisc() {
    if (promisc->isChecked())
        pdoc->setPromisc(true);
    else
        pdoc->setPromisc(false);
}

void KConf::setUpdateTime(int value){
    pdoc->setUpdateTime(value*1000);
}

void KConf::setInactiveTime(int value){
    pdoc->setInactiveTime(value*1000);    
    pdoc->restartInactiveTimer();
}

void KConf::setPacketMax(int value){
    pdoc->setPacketMax(value);
}

void KConf::setFilter() {
    pdoc->setFilter(ieee802->isChecked(),
                    arp->isChecked(), 
                    ip->isChecked(),
                    tcp->isChecked(),
                    udp->isChecked(),
                    icmp->isChecked(),
										x->isChecked(),
                    atoi(LineEdit_Port->text()));
}

void KConf::ok () {
    setInterface();
    setPromisc();
    setFilter();
    setUpdateTime(updateTime->value());
    setInactiveTime(inactiveTime->value());
    setPacketMax(numPackets->value());
    setAddrList();
    pdoc->saveMyOptions();
    accept();
}

void KConf::confCancel() {
    reject();
}

void KConf::ipCheckboxToggled(bool ipOn) {
    tcp->setEnabled(ipOn);
    udp->setEnabled(ipOn);
    icmp->setEnabled(ipOn);
    x->setEnabled(ipOn);
    LineEdit_Port->setEnabled(ipOn);
}

void KConf::tcpudpCheckboxToggled(bool) {
    if (tcp->isChecked() || udp->isChecked())
        LineEdit_Port->setEnabled(true);
    else {
        LineEdit_Port->setEnabled(false);
				x->setEnabled(false);
 		}
}

void KConf::resolveToggled(bool resolve) {
    pdoc->setHostResolve(resolveName->isChecked());
}

void KConf::asciiOutputToggled(bool output) {
    pdoc->setasciiOutput(asciiOutput->isChecked());
}

void KConf::filterNewNodes(bool) {
    pdoc->setSelectNode(addrSelect->isChecked());
}

void KConf::setAddrBox() {
    ListView->clear();
    // paint each node (and set the checkbox according isNodeSelected)
    for (int i=pdoc->getNodeNum()-1; i>=0; i--) {
        // fill ListBox
        register QCheckListItem *item= new QCheckListItem(ListView,(const char *)pdoc->getNode(i), QCheckListItem::CheckBox );
        item->setText(1, pdoc->getNodeDomainName(pdoc->getNode(i)));
        // set seleted items
        item->setOn(pdoc->isNodeSelected((const char *) pdoc->getNode(i)));
    }
}

void KConf::setAddrList() {  // (de)select nodes in pdoc, according checkbox
    QListViewItem *first= ListView->firstChild();
    for (int i=ListView->childCount(); i>0 ;i--, first=first->nextSibling()) {
        register QCheckListItem *item= (QCheckListItem *)first;
        pdoc->setNodeSelected(item->text(), item->isOn());
    }
}

void KConf::slotNewAddr() {
    if (pdoc->getNodeNum()!=actualSize) {
        actualSize=pdoc->getNodeNum();
        
        // get actual set nodes, and setNodeSelected accordingly
        setAddrList();
        // insert new nodes in ListView
        setAddrBox();
    }
    emit gotData();
}

void KConf::addAddr() {
    QString host2Add;
    
    host2Add  = LineEdit_1->text(); 
    host2Add += '.'; 
    host2Add += LineEdit_2->text();
    host2Add += '.'; 
    host2Add += LineEdit_3->text();
    host2Add += '.';
    host2Add += LineEdit_4->text();

    pdoc->storeNode(host2Add);

    setAddrBox();
    // pdoc->sendPing((const char *) host2Add);  // to invoke a packet to the desired host
}

void KConf::selectNodes () {
    // select all nodes
    for (int i=pdoc->getNodeNum()-1; i>=0; i--) 
        pdoc->setNodeSelected((const char *) pdoc->getNode(i), true);
    setAddrBox();
}

void KConf::deselectNodes () {
    // deselect all nodes
    for (int i=pdoc->getNodeNum()-1; i>=0; i--) 
        pdoc->setNodeSelected((const char *) pdoc->getNode(i), false);
    setAddrBox();
}

