/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/


#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qstring.h>


#define PAPER_A4        0
#define PAPER_B4        1
#define PAPER_B5        2
#define PAPER_LETTER    3
#define PAPER_LEGAL     4
#define PAPER_EXECUTIVE 5


#define KMLOFAX_DIR						"share/apps/kmlofax"
#define KMLOFAX_FAXDIR				"facsimilerc"
#define KMLOFAX_ALIASLIST			"aliasesrc"

#define ID_PREF_GROUP_GENERAL	"General"
#define ID_PREF_GEN_TOOLTIPS	"ToolTips"
#define PREF_GEN_TOOLTIPS			TRUE
#define ID_PREF_GEN_LOADNEW		"DownloadNew"
#define PREF_GEN_LOADNEW			FALSE
#define ID_PREF_GEN_DELETEFAX	"DeleteFax"
#define PREF_GEN_DELETEFAX		TRUE

#define ID_PREF_GROUP_MODEM		"Modem"
#define ID_PREF_MOD_DEVICE		"Device"
#define PREF_MOD_DEVICE   		"/dev/modem"
#define ID_PREF_MOD_SPEED			"Speed"
#define PREF_MOD_SPEED    		1		// == 38400 Bps

#define ID_PREF_GROUP_PRINT		"Print"
#define ID_PREF_PRT_COMMAND		"Command"
#define PREF_PRT_COMMAND			"lpr -Plp"
#define ID_PREF_PRT_PAPER			"Paper"
#define PREF_PRT_PAPER				PAPER_A4
#define ID_PREF_PRT_LMARGIN		"LeftMargin"
#define PREF_PRT_LMARGIN			0
#define ID_PREF_PRT_RMARGIN		"RightMargin"
#define PREF_PRT_RMARGIN  		0
#define ID_PREF_PRT_TMARGIN		"TopMargin"
#define PREF_PRT_TMARGIN  		0
#define ID_PREF_PRT_BMARGIN		"BottomMargin"
#define PREF_PRT_BMARGIN  		0
#define ID_PREF_PRT_LEVEL2		"LanguageLevel2"
#define PREF_PRT_LEVEL2				TRUE
#define ID_PREF_PRT_INTERPOL	"Interpolate"
#define PREF_PRT_INTERPOL			FALSE

#define ID_PREF_GROUP_MAIL		"Mail"
#define ID_PREF_MAIL_SERVER		"Server"
#define PREF_MAIL_SERVER			"localhost"
#define ID_PREF_MAIL_PORT			"Port"
#define PREF_MAIL_PORT				25
#define ID_PREF_MAIL_NAME			"Name"
#define PREF_MAIL_NAME				""
#define ID_PREF_MAIL_ORG			"Organization"
#define PREF_MAIL_ORG					""
#define ID_PREF_MAIL_EMAIL		"Email"
#define PREF_MAIL_EMAIL				""
#define ID_PREF_MAIL_REPLY		"Reply"
#define PREF_MAIL_REPLY				""


#define ID_FILE_DOWNLOAD           10010
#define ID_FILE_VIEW               10020
#define ID_FILE_PRINT              10030
#define ID_FILE_EXPORT             10040
#define ID_FILE_MAIL               10050
#define ID_FILE_DELETE             10060
#define ID_FILE_SENDER_ALIAS       10070
#define ID_FILE_PURGE_DIRECTORY    10080
#define ID_FILE_REBUILD_DIRECTORY  10090
#define ID_FILE_QUIT               10100

#define ID_OPTIONS_PREFERENCES     11010
#define ID_OPTIONS_SENDER_ALIASES  11020
#define ID_OPTIONS_TOOLBAR         11030
#define ID_OPTIONS_STATUSBAR       11040

#define ID_HELP_CONTENTS           1002
#define ID_HELP_ABOUT              1003

#define ID_STATUS_MSG              1001



#define SENDER_ALIAS(x) (senderaliases->alias(x))



extern const uchar xchg_endian[];

bool testDir(const char *path);

QString expandPath(const char *fname);

QString mloDateStr(const char *name);

void mloDateSplit(const char *name, int *year, int *month, int *day, int *hour, int *minute, int *second);

#endif // GLOBAL_H
