#ifndef KMEMSTATWIDGET_H 
#define KMEMSTATWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qscrbar.h>
#include <qevent.h>

#include "memdata.h"
#include "mem_zone.h"

class KMemStat ;

class KMemStatWidget : public QWidget
{
	Q_OBJECT

	friend KMemStat ;

public:
	KMemStatWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KMemStatWidget();

public slots:
	void redraw() ; 
	void setScrollbarValue(int) ;

protected slots:
	void resizeEvent( QResizeEvent *) ;
	void mousePressEvent( QMouseEvent * ) ;
signals:
	void notifyMousePressEvent( QMouseEvent * ) ;

private:
	QLabel *status ;
	QScrollBar *scrollbar ;

	/* main view */
	MemZone *memzone ;
	/* data */
	MemData *memdata ;

	/* replace this with real variables later on */
	int he() ;
	int wi() ;
};

#endif // KMEMSTATWIDGET_H 
