#ifndef DIALOGS_H
#define DIALOGS_H

#include <qdialog.h>
#include <qtabdlg.h>
#include <qlabel.h>
#include <kcolorbtn.h>

#include "myintegerline.h"

class KMemStat ;
class ConfigureWidget;
class DisplayDialog ;
class ColorDialog ;

static const int widget_space = 10 ;

class ConfigureWidget : public QTabDialog
{
	friend KMemStat ;

	Q_OBJECT

public:
	ConfigureWidget( QWidget *, const char * ) ;
	~ConfigureWidget() ;

private:

	DisplayDialog *display_tab ;
	ColorDialog *color_tab ;
//	etc.

};

class DisplayDialog : public QWidget
{
	Q_OBJECT

public:
	DisplayDialog( QWidget *parent, const char *name ) ;
	~DisplayDialog() ;

	int pagesOnRow() ;
	int updateTime() ;
public slots:
	void pagesOnRow(int) ;
	void updateTime(int) ;
private:
	MyIntegerLine *pagesOnRowLine, *updateTimeLine ;
	int pages_on_row, update_time ;
};

class ColorDialog : public QWidget
{
	Q_OBJECT

public:
	ColorDialog( QWidget *parent, const char *name ) ;
	~ColorDialog() ;

	QColor getColor( int ) ;
public slots:
	void setColor( const QColor &, int pos ) ;

private:
	QLabel **labels ;
	KColorButton **colors ;
};

#endif
