/* memmap.h 
 *
 * Header file
 */

#ifndef MEMMAP_H
#define MEMMAP_H

/* want debugging? */
#define MEMMAP_DEBUG 1

#include <linux/config.h>
/* We're using multiple source files */
#define __NO_VERSION__

#ifdef __KERNEL__
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <linux/errno.h>  /* error codes */
#include <linux/types.h>  /* size_t */
#endif

#include <linux/ioctl.h>

// protect userland programs :-)
#ifdef __KERNEL__

#define KP KERN_NOTICE

typedef struct MemmapDevice {
   void **data;
   unsigned long size;		/* number of pages */
   unsigned int usage;		/* lock the device while using it */
} MemmapDevice ;

#endif /* __KERNEL__ */

/* Some defines */

/* maximum amount of data that can be read */
#define MAX_DATA_SIZE 256 

/* types of memory */
#define MEMMAP_MEM_FREE 0 		/* free memory */
#define MEMMAP_MEM_USED 1
#define MEMMAP_MEM_CACHED 2             /* cached */
#define MEMMAP_MEM_BUF 3 
#define MEMMAP_MEM_RESERVED 4 		/* reserved (for example kernel) */
#define MEMMAP_MEM_ERROR 5 		/* something went wrong */

#ifdef __KERNEL__

/* data */
extern int memmap_major	;		/* main.c */
extern int memmap_nr_devs ;
extern MemmapDevice *memmap_device ;

/*
 * Prototypes for shared functions
 */
extern int memmap_open(struct inode *, struct file * ) ;
extern int memmap_release(struct inode *, struct file *) ;

extern ssize_t memmap_read( struct file *, char *, size_t, loff_t * );
extern loff_t memmap_lseek( struct file *, loff_t, int ) ;
extern int memmap_ioctl( struct inode *, struct file *, unsigned int,
				unsigned long ) ;
extern char mem_type( struct page * ) ;
#endif /* __KERNEL__ */

/*
 * Ioctl definitions
 */

#define MEMMAP_IOCTL_MAGIC 'p'
#define MEMMAP_IOCTL_MAXNR 2

/* return the number of pages */
#define MEMMAP_IOCTL_GET_NR_OF_PAGES _IOR(MEMMAP_IOCTL_MAGIC, 0, int )
#define MEMMAP_IOCTL_GET_PAGE _IOWR(MEMMAP_IOCTL_MAGIC, 1, int ) 
#ifdef MEMMAP_DEBUG
  /* reset MOC_INC_USE_COUNT */
  #define MEMMAP_IOCTL_RESET _IO(MEMMAP_IOCTL_MAGIC, 2 )
#endif

#endif
