#ifndef _MAINDLG_H_
#define _MAINDLG_H_

#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kprocess.h>
#include <qlistbox.h>
#include "mainView.h"

// FIXME Add a viewing Support for postscriptPrinters
// FIXME Keep track of the selected Print job  
//

class mainDlg : public KTopLevelWidget
{
    Q_OBJECT;

public:
    mainDlg
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );
 
    void SetupMainMenuBar();
    
    void SetupToolBar();
    void DestroyToolBar();
    void updateToolBarComboBox();
    
    void SetupStatusBar();
    void DestroyStatusBar();
    
    void SetupListBox();
    void DestroyListBox();
 
    void Interface();
 
    virtual ~mainDlg();
    	
private:    
    	/* MainMenuBar */
    	KMenuBar *menubar;
	
    	/* Menus */
    	QPopupMenu *file;
	QPopupMenu *edit;
	QPopupMenu *options;
	QPopupMenu *help;
	
	/* ToolBar */

	KToolBar *toolbar;
	int toolbar1;

#define ID_LINE_COLUMN 1
#define ID_INS_OVR 2
#define ID_GENERAL 3

	
	/* StatusBar */
	KStatusBar* statusbar;
	

	/* QComboBox */

	QComboBox *ComboBox;
	
	/* View */
	mainView *myView;

	
public slots:

	/* Filemenu Items */

	void PrinterMenuNew();
	void PrinterMenuOpen();
	void PrinterMenuClose();
	void PrinterMenuSave();
	void PrinterMenuSaveAs();
	void PrinterMenuExit();
	
	/* Editmenu Items */

	void EditMenuUndo();
	void EditMenuCut();
	void EditMenuCopy();
	void EditMenuPaste();
	
	/* Optionsmenu Items */

	void OptionsMenuConfigure();
	
	
	void ListPrintQueue();

protected slots:
	
};
#endif
