/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: klm.h,v 1.25 1999/02/07 17:09:17 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef KLM_H
#define KLM_H

#include <ktopwidget.h>
#include <kiconloader.h>
#include <kled.h>
#include <kstatusbar.h>
#include <qwindow.h>
#include <qtimer.h>

#include <linux/sensors.h>

#include "Sensors.h"
#include "LMStats.h"
#include "DockWidget.h"
#include "VertGraph.h"
#include "DockWidget.h"

class Settings;

class Klm : public KTopLevelWidget
{
  Q_OBJECT
  
  enum { 
    NONE = 0, 
    LM75, 
    LM78, 
    LM79, 
    LM80, 
    W83781D, 
    GL518, 
    ADM1021, 
    ADM9240,
    SIS5595	};
  
private:
  QTimer      *myTimer;	
  QPopupMenu  *file;
  QPopupMenu  *help;
  KMenuBar    *kdemenu;
  KToolBar    *tb;
  KStatusBar  *statusBar;	
  KIconLoader *il;
  KLed        *led;
  KConfig     *config;
  LMStats     *lmstats;	
  DockWidget  *dock;
  Settings    *settings;
  MachineType machine;
  bool        beepOnAlarm;
  bool        scriptOnAlarm;
  QString     scriptCommand;
  long        refreshInterval;
  
  int dockDisplayedPtr;
  int numLm75Chips;
  
  void rebuild( bool override );
  
  void readSensorDirectory(
    sensors_chips_data *buf, 
    int len, 
    int &num_sensor_chips);
  
  int getSensorType( sensors_chips_data dirEntry );
  
  void addLm75( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );	
  void addLm78( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addLm79( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addLm80( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addW83781d( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addSis5595( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );	
  void addGl518( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addAdm1021( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  void addAdm9240( 
    sensors_chips_data dirEntry, 
    int &sensorCount,
    bool override );
  
  bool isIgnorable( 
    bool ignoreISA, 
    bool ignoreI2c, 
    sensors_chips_data dirEntry );	
  void probeSensors( bool override );
  void checkDisabled( int &idx, bool override );
  bool testSensorPresence( int sysctl_addr2, int sysctl_addr3 );
  
  void getAppSettings();
  void saveAppSettings();
  
  void execCommand( const QString command );
  
public:
  
  Klm
  (
    QWidget* parent = NULL,
    const char* name = NULL
      );
  
  ~Klm();
  
  void updateDisplay();
  
public slots:
  void saveQuit();
  void save();
  void maxOrMin();
  void reInitialise();
  void sensorDisabled();
  void timerExpired();
  void showSettings();
  void hideSettings();
  void newUpdateInterval( int );	
  void alarmBeepToggled( bool );
  void alarmScriptToggled( bool );
};



#endif // LMStats_included
