/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: LMStats.cpp,v 1.26 1999/01/09 18:55:57 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kapp.h>
#include <kmsgbox.h>
#include <kstatusbar.h>
#include <qaccel.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmenubar.h>

#include "Item.h"
#include "LMStats.h"
#include "Sensors.h"
#include "klm.h"

extern Klm *w;

LMStats::LMStats
(
  QWidget    *parent,
  const char *name,
  MachineType *machine,
  KStatusBar *statusBar	)
:
QWidget( parent, name )
{
  int i = 0;
  int width = 0;
  int height = 0;
  
  m = machine;
  
  QGridLayout* qtarch_layout_1 = new QGridLayout( 
      this, 
      1, 
      machine->num_sensors,
      5, 5,  
      NULL );
  
  
  for( i=0; i<machine->num_sensors; i++)
  {
    machine->graphs[i] = new VertItem(
        this,
        "a_graph",
        statusBar,
        machine->sensors[i] );
    
    connect(
      machine->graphs[i], SIGNAL( hideMe() ),
      this, SLOT( graphDisabled() ) );
    
    qtarch_layout_1->addColSpacing( i, 5 );
    qtarch_layout_1->setColStretch( i, 1 );
    qtarch_layout_1->addWidget( machine->graphs[i], 0, i, 36 );
    
    width += machine->graphs[i]->width();		
    if ( machine->graphs[i]->height() > height )
    {
      height = machine->graphs[i]->height();
    }
    
    setGeometry( 0, 0, width, height );		
  }
}	

LMStats::~LMStats()
{
  int i;
  
  for( i=0; i<m->num_sensors; i++)
  {
    delete m->graphs[i];
  }
}

void LMStats::update()
{
  
}

void LMStats::saveQuit()
{
}

void LMStats::graphDisabled()
{
  emit( reloadMe() );
}


#include <LMStats.moc.cpp>
