/* -------------------------------------------------------------

   toplevel.cpp (part of K HTML Imager)

   (C)  by Andreas Heck

   Generated with the KDE Application Generator

 ------------------------------------------------------------- */


#include "toplevel.h"
#include "qmessagebox.h"


TopLevel::TopLevel()
  : KTopLevelWidget()
{
 optionsGroup = new QGroupBox(this);
 optionsGroup->setGeometry(5,5,440,320);
 optionsGroup->setFrameStyle( QFrame::Box | QFrame::Sunken);

 dirLabel = new QLabel(optionsGroup);
 dirLabel->move(10,20);
 dirLabel->setAutoResize(true);
 dirLabel->setText("Directory to Filter:");

 dirBox = new QLineEdit(optionsGroup);
 dirBox->setGeometry(10,40,140,25);

 dirBrowseButton = new QPushButton(optionsGroup);
 dirBrowseButton->setGeometry(160,40,30,25);
 dirBrowseButton->setText("...");
 connect(dirBrowseButton, SIGNAL(clicked()), this, SLOT(browseDir()));

 outputLabel = new QLabel(optionsGroup);
 outputLabel->move(260,20);
 outputLabel->setAutoResize(true);
 outputLabel->setText("HTML Output File");

 outputFileBox = new QLineEdit(optionsGroup);
 outputFileBox->setGeometry(260,40,140,25);
 outputFileBox->setText("images.html");

 filterButton = new QPushButton(optionsGroup);
 filterButton->setGeometry(270,240,100,25);
 filterButton->setText("&Filter");

 connect(filterButton, SIGNAL(clicked()), this, SLOT(filterDir()));

 filterLabel = new QLabel(optionsGroup);
 filterLabel->move(270,280);
 filterLabel->setAutoResize(true);
 filterLabel->setText("Filtered Files:");

 numFilesLabel = new QLabel(optionsGroup);
 numFilesLabel->move(370,280);
 numFilesLabel->setAutoResize(true);
 numFilesLabel->setText("0");

 optionsButton = new QPushButton(this);
 optionsButton->setGeometry(5,360,100,25);
 optionsButton->setText("&Options");

 aboutButton = new QPushButton(this);
 aboutButton->setGeometry(130,360,100,25);
 aboutButton->setText("&About");
 connect(aboutButton, SIGNAL(clicked()), this, SLOT(aboutApp()));

 quitButton = new QPushButton(this);
 quitButton->setGeometry(340,360,100,25);
 quitButton->setText("&Quit");
 connect(quitButton, SIGNAL(clicked()), kapp, SLOT(quit()));

 setCaption("K HTML Imager");
 setFixedSize(450,400);
}

TopLevel::~TopLevel()
{

}

void TopLevel::aboutApp()
{
  QMessageBox::about(this, i18n("About K HTML Imager 0.1"), i18n("K HTML Imager 0.1\n\n(C) 1998 Andreas Heck (aheck@heilbronn.netsurf.de)"));
}

void TopLevel::browseDir()
{
 QString filename = KFileDialog::getDirectory("",this,"");
 if (filename != NULL)
     dirBox->setText(filename);
}

void TopLevel::filterDir()
{
 int numofFiles = 0;
 char *text = NULL;

 htmlimager = new HTMLImager;
 numofFiles = htmlimager->createHTML(dirBox->text(), outputFileBox->text(), true);
 if (numofFiles < 0)
   return;
 asprintf(&text,"%d",numofFiles);
 numFilesLabel->setText(text);
}
