/*
 * khotkeys.cpp
 *
 * Copyright (C) 1999 Lubos Lunak <l.lunak@email.cz>
 */

#include "khotkeys.h"
#include <kwm.h>
#include <ksimpleconfig.h>
#include <X11/X.h>
#include <X11/Xutil.h>
#include <qregexp.h>

//#ifdef HAVE_KFMEXEC   CHECKME 
//#include <kfmexec.h>
//#else
#include <kprocess.h>
#include <kfm.h>
//#endif

int main( int argc, char** argv )
    {
    KHotKeysApp app( argc, argv );
    if( app.run_it())
	app.exec();
    return 0;
    }
    
KHotKeysApp::KHotKeysApp( int& argc, char* argv[] )
    : KWMModuleApplication( argc, argv ), kga( NULL ), hotkeys_data( 53 )
    {
    unique_win = new QWidget;
    if( !check_unique())
	{
	delete unique_win;
	unique_win = NULL;
	}
    else
	{
        hotkeys_data.setAutoDelete( true );
        windows_active.setAutoDelete( true );
        connect( this, SIGNAL( windowAdd( Window )), this, SLOT( window_add( Window )));
        connect( this, SIGNAL( windowChange( Window )), this, SLOT( window_add( Window )));
        connect( this, SIGNAL( windowRemove( Window )), this, SLOT( window_remove( Window )));
        connect( this, SIGNAL( windowActivate( Window )), this, SLOT( window_active( Window )));
        connect( this, SIGNAL( commandReceived( QString )), this, SLOT( command_received( QString )));
        kga = new KHKGlobalAccel;
        CHECK_PTR( kga );
        connectToKWM();
        readSettings();
	}
    } 
    
KHotKeysApp::~KHotKeysApp()
    {
    delete unique_win;
    delete kga;
    }
    
bool KHotKeysApp::x11EventFilter( XEvent *ev )
    {
    if( kga->x11EventFilter( ev ) )
	return true;
    return KWMModuleApplication::x11EventFilter( ev );
    }

void KHotKeysApp::window_add( Window w )
    {
    Window* w_iter;
    for( w_iter = windows_active.first();
	 w_iter != NULL;
	 w_iter = windows_active.next())
	if( *w_iter == w )
	    break;
    if( w_iter == NULL )
	windows_active.insert( 0, new Window( w ));
    }

void KHotKeysApp::window_active( Window w )
    {
    QDictIterator< KHotData > iter( hotkeys_data );
    for( iter.toFirst();
	 iter.current();
	 ++iter )
        {
	KHotData* pos = iter.current();
	if( pos->run_type == macro )
	    continue;     // no need to bother with macros
	if(( pos->win_search == any
		&& !iter.current()->is_act_window
		    && window_match( iter.current(), w ))
	    || ( pos->win_search == created
		&& !iter.current()->is_act_window
		&& iter.current()->one_act_timer.isActive()
		&& window_match( iter.current(), w ))
	    || ( pos->win_search == last
		&& window_match( iter.current(), w )))
	    {
            iter.current()->act_window = w;
            iter.current()->is_act_window = true;
	    iter.current()->one_act_timer.stop();
	    }
	}
    }


void KHotKeysApp::window_remove( Window w )
    {
    QDictIterator<KHotData> iter( hotkeys_data );
    iter.toFirst();
    while( iter.current())    // cancel this window in act_window
	{
	if( iter.current()->act_window == w )
	    iter.current()->is_act_window = false;
	++iter;
	}
    for( Window* w_iter = windows_active.first();
	 w_iter != NULL;
	 w_iter = windows_active.next())
	if( *w_iter == w )
	    windows_active.remove();
    }
    
bool KHotKeysApp::window_match( KHotData* data, Window w )
    {
    if( !data->use_command && !data->use_title && !data->use_class )
	return false;
    if( data->use_command
	&& !is_w_par_t_match( data->command, get_window_command( w ), data->use_command))
	return false;
    if( data->use_title
	&& !is_w_par_t_match( data->wtitle, get_window_title( w ), data->use_title ))
	return false;
    if( data->use_class
	&& !is_w_par_t_match( data->wclass, get_window_class( w ), data->use_class))
	return false;
    return true;
    }
    
bool KHotKeysApp::is_w_par_t_match( const QString& str1, const QString& str2,
  w_par_t par_t )
    {
    switch( par_t )
	{
	case not_sig :
	  return true;
	case if_ex :
	  return str1 == str2;
	case if_exp :
	  return QRegExp( str1 ).match( str2 ) > -1;
	default :
	  return false;
	}
    }    
    
QString KHotKeysApp::get_window_command( Window w )
    {
    char** argv_ret;
    int argc_ret;
    if( XGetCommand( qt_xdisplay(), w, &argv_ret, &argc_ret ) == 0 ) // 0 means error
	return "";
    if( argv_ret == NULL )
	return "";
    QString ret( argv_ret[ 0 ] );
    for( int cnt = 1;
	 cnt < argc_ret;
	 ++cnt )
	{
	ret += ' ';
	ret += argv_ret[ cnt ];
	}
    XFreeStringList( argv_ret );
    return ret;
    }
    
QString KHotKeysApp::get_window_title( Window w )
    {
    XTextProperty text_ret;
    char** list_ret;
    int list_cnt;
    if( XGetWMName( qt_xdisplay(), w, &text_ret ) == 0 ) // 0 means error
	return "";  // CHECKME ?? KWM_WIN_TITLE ???
    if( XmbTextPropertyToTextList( qt_xdisplay(), &text_ret, &list_ret, &list_cnt ) != Success )
	return "";
    QString ret;
    for( int cnt = 0;
         cnt < list_cnt;
         ++cnt )
        ret += list_ret[ cnt ];
    XFreeStringList( list_ret );
    return ret;
    }
    

QString KHotKeysApp::get_window_class( Window w )
    {
    XClassHint hints_ret;
    if( XGetClassHint( qt_xdisplay(), w, &hints_ret ) == 0 ) // 0 means error
	return "";
    QString ret( hints_ret.res_name );
    ret += ' ';
    ret += hints_ret.res_class;
    XFree( hints_ret.res_name );
    XFree( hints_ret.res_class );
    return ret;
    }


void KHotKeysApp::got_hotkey( const char*, const QString&, uint keyCode )
    {
    QDictIterator< KHotData > iter( hotkeys_data );
    iter.toFirst();
    while( iter.current())
	{
	if( kga->currentKey( iter.currentKey()) == keyCode )
	    {
	    switch( iter.current()->run_type )
		{
		case run :
		case url :
		    run_app( iter.current() );
		  break;
		case macro :
		    run_macro( iter.current() );
		  break;
		default :  // oops CHECKME
		  break;
		}
	    return; // CHECKME couldn't run check ?
	    }
	++iter;
	}
    // CHECKME not found ???
    }

// reset all hotkeys to status not-loading    
void KHotKeysApp::reset_status()
    {
    QDictIterator< KHotData > iter( hotkeys_data );
    iter.toFirst();
    while( iter.current())
	{
	iter.current()->one_act_timer.stop();
	++iter;
	}
    }
    
void KHotKeysApp::command_received( QString comm )
    {
    if( comm.lower() == "khotkeys:reset" )
	reset_status();
    else if( comm.lower() == "khotkeys:reload" )
	{
	delete kga;
	kga = new KHKGlobalAccel;
	CHECK_PTR( kga );
	hotkeys_data.clear();
        readSettings();
	}
    }
	
    
void KHotKeysApp::run_app( KHotData* data )
    {
    if( data->is_act_window && hasWindow( data->act_window )
	&& window_match( data, data->act_window ))
        {
        KWM::activate( data->act_window );
        return;
        }
    if( data->win_search != created )
	{ // search last active windows ( even for 'any' )
	for( Window* w_iter = windows_active.first();
	     w_iter != NULL;
	     w_iter = windows_active.next())
	    if( window_match( data, *w_iter ))
		{
		data->is_act_window = true;
		data->act_window = *w_iter; // CHECKME that stupid warning
		KWM::activate( data->act_window );
		return;
		}
	}
    if( data->one_act_timer.isActive())	// loading
	return;
    data->is_act_window = false;
    if( data->win_search == created )
	data->one_act_timer.start( one_act_timeout, true ); // 1 minute timeout
//#ifdef HAVE_KFMEXEC
//    KFMExec* kfm_exec = new KFMExec;
//    kfm_exec->openUrl( data->run_command );
//#else
    if( data->run_type == run )
	{
        KShellProcess proc;
        proc << data->run_command;
        proc.start( KShellProcess::DontCare );
	}
    else
	{
	KFM* kf = new KFM; // CHECKME doesn't work ?!?!
	kf->openURL( data->run_command );
	delete kf;
//	KShellProcess proc;
//	proc << "kfmclient openURL" << data->run_command;
//	proc.start( KShellProcess::DontCare );
	}
//#endif
    }
    
void KHotKeysApp::run_macro( KHotData* data )
    {
    if(( data->use_command || data->use_title || data->use_class )
	&& !window_match( data, KWM::activeWindow())) // CHECKME
	return;
    if( data->run_command == "" )
	return;
    int last_index = -1, start = 0;
    while(( last_index = data->run_command.find( ':', last_index + 1 )) != -1 ) // find next ';'
	{
	send_macro_key( stringToKey(
	    data->run_command.mid( start, last_index - start )));
	start = last_index + 1;
	}
    // and the last one
    send_macro_key( stringToKey(
        data->run_command.mid( start, data->run_command.length()))); // the rest
    }
	
void KHotKeysApp::send_macro_key( uint keycode )
    {
    XKeyEvent ev;
    ev.type = KeyPress;
    ev.display = qt_xdisplay();
    ev.window = qt_xrootwin(); // ok, let's guess some values
    ev.root = qt_xrootwin();   // I don't know whether these have to be set
    ev.subwindow = None;       // to these values, but it seems to work, hmm
    ev.time = CurrentTime;
    ev.x = 0;
    ev.y = 0;
    ev.x_root = 0;
    ev.y_root = 0;
    if( keycode == Key_Enter  // ugly hack
	&& XKeysymToKeycode( qt_xdisplay(), keyToXSym( keycode )) == NoSymbol )
	keycode = Key_Return;
    else if( keycode == Key_Return
	    && XKeysymToKeycode( qt_xdisplay(), keyToXSym( keycode )) == NoSymbol )
	keycode = Key_Enter;
    ev.state = keyToXMod( keycode );
    ev.keycode = XKeysymToKeycode( qt_xdisplay(), keyToXSym( keycode ));
    if( ev.keycode == NoSymbol )
	return;
    ev.same_screen = true;
    XSendEvent( qt_xdisplay(), InputFocus, false, 0, ( XEvent* )&ev );
#if 1
    ev.type = KeyRelease;  // is this actually really needed ??
    ev.display = qt_xdisplay();
    ev.window = qt_xrootwin();
    ev.root = qt_xrootwin();
    ev.subwindow = None;
    ev.time = CurrentTime;
    ev.x = 0;
    ev.y = 0;
    ev.x_root = 0;
    ev.y_root = 0;
    ev.state = keyToXMod( keycode );
    ev.keycode = XKeysymToKeycode( qt_xdisplay(), keyToXSym( keycode ));
    ev.same_screen = true;
    XSendEvent( qt_xdisplay(), InputFocus, false, 0, ( XEvent* )&ev );
#endif
    }
    
void KHotKeysApp::readSettings()
    {
    KConfig conf( kde_configdir() + "/kcmhotkeysrc", localconfigdir() + "/kcmhotkeysrc" );
    conf.setGroup( "Main" );
    one_act_timeout = conf.readLongNumEntry( "Timeout", 60 * 1000 ); // 1 minute by default
    uint reset_keycode = stringToKey( conf.readEntry( "Reset hotkey", "" ));
    KConfig conf_old; // global config file
    KEntryIterator* keyiter = conf_old.entryIterator( "KHotKeys" );
    int num_sections = conf.readNumEntry( "Num_Sections", 0 );
    if( num_sections <= 0 )
	return;
    for( int cnt = 1;
	 cnt <= num_sections;
	 ++cnt )
	{
	char tmp[ 100 ];
	sprintf( tmp, "Section%i", cnt );
	conf.setGroup( tmp );
	if( strcmp( conf.group(), tmp ) != 0 ) // no such Section
	    continue;
	QString name = conf.readEntry( "Name", "" );
	if( name == "" || hotkeys_data.find( name ))
	    continue;
	QString type = conf.readEntry( "Type", "" );
	run_type_t run_type;
	if( type == "run" )
	    run_type = run;
	else if( type == "macro" )
	    run_type = macro;
	else if( type == "url" )
	    run_type = url;
	else
	    continue;
	KHotData* data = new KHotData;
	data->run_type = run_type;
	data->run_command = conf.readEntry( "RunCommand", "" );
	data->use_command = str_to_w_par_t( conf.readEntry( "UseCommand" ));
	data->command = conf.readEntry( "Command", "" );
	data->use_title = str_to_w_par_t( conf.readEntry( "UseTitle" ));
	data->wtitle = conf.readEntry( "Title", "" );
	data->use_class = str_to_w_par_t( conf.readEntry( "UseClass" ));
	data->wclass = conf.readEntry( "Class", "" );
        bool one_act_win = conf.readBoolEntry( "OnlyOneAppWin" )
	    && ( run_type != macro ); // CHECKME backward compatibility
	QString w_s = conf.readEntry( "WinSearch", "" );
	if( w_s == "Last" )
	    data->win_search = last;
	else if( w_s == "Created" )
	    data->win_search = created;
	else if( w_s == "Any" )
	    data->win_search = any;
	else
	    data->win_search = one_act_win ? created : any;
	data->is_act_window = false;
        QString keycode_txt = conf.readEntry( "Hotkey", "" );
        uint keycode = stringToKey( keycode_txt );
	if( keyiter != NULL && keycode == 0 ) // CHECKME backward compatibility
    	    {
	    keyiter->toFirst();
	    while( keyiter->current())
	        {
		if( name == keyiter->currentKey())
		    {
		    keycode = stringToKey( keyiter->current()->aValue );
		 break;
		    }
		++(*keyiter);
		}
	    }
	hotkeys_data.insert( name, data );
	kga->insertItem( name, name, keycode );
	kga->connectItem( name, this, SLOT(got_hotkey( const char*, const QString&, uint )));
	}
    kga->insertItem( "Reset status", "KHotKeysReset", reset_keycode );
    kga->connectItem( "KHotKeysReset", this, SLOT( reset_status()));
//    kga->setConfigGroup( "KHotKeys" );
//    kga->readSettings();
    if( keyiter != NULL )
	delete keyiter;
    }

static char* txts[] =
	{ "notsignificant", "ifexists", "regexp" };

const char* KHotKeysApp::w_par_t_to_str( w_par_t type )
    {
    return txts[ type ];
    }
    
KHotKeysApp::w_par_t KHotKeysApp::str_to_w_par_t( const QString& str )
    {
    for( unsigned int i = 0;
	 i < sizeof( txts ) / sizeof( txts[ 0 ] );
	 ++i )
	if( txts[ i ] == str )
	    return ( w_par_t ) ( i ); // static_cast<>
    return not_sig;
    }

bool KHotKeysApp::check_unique()
    {
    static Atom unique_atom = XInternAtom( qt_xdisplay(), "KHotKeysUnique", false );
    if( !query_unique( qt_xrootwin(), unique_atom ))
	return false;
    unsigned char dummy = 1;
    XChangeProperty( qt_xdisplay(), unique_win->winId(), unique_atom, unique_atom, 8,
	PropModeReplace, &dummy, 1); 
    return true;
    }
    
bool KHotKeysApp::query_unique( Window w, Atom unique_atom )
    {
    Atom type_ret;
    int format_ret;
    unsigned long ret_1, ret_2;    
    unsigned char* prop;
    if( XGetWindowProperty( qt_xdisplay(), w, unique_atom, 0, 0, false,
	AnyPropertyType, &type_ret, &format_ret, &ret_1, &ret_2, &prop) == Success
	&& (type_ret != None))
	return false;
    Window parent, root;
    Window* children;
    unsigned int n;
    if( XQueryTree( qt_xdisplay(), w, &root, &parent, &children, &n ) == 0 )
	return true;
    for( unsigned int i = 0;
	 i < n;
	 ++i )
	if( !query_unique( children[ i ], unique_atom ))
	    {
	    XFree( children );
	    return false;
	    }
    XFree( children );
    return true;
    }


