/*
 * klistedit.h
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _KLISTEDIT_H
#define _KLISTEDIT_H

#include <qpushbt.h>
#include <qlcdnum.h>
#include <qgrpbox.h>
#include <qstrlist.h>
#include <qlined.h>
#include <qlabel.h>
#include <qaccel.h>

#include <kstdaccel.h>

class KStrListEdit : public QWidget {
    Q_OBJECT

 public:
   /** construct a KStrListEdit Widget with a 
       given QStrList **/
   KStrListEdit(QStrList *data,QWidget *parent=0,const char *name=0);

   /** construct a KStrListEdit Widget **/
   KStrListEdit(QWidget *parent=0,const char *name=0);

   /** returns TRUE if there are no strings stored **/
   bool isEmpty();

   /** returns the number of stored strings **/
   unsigned int count();
   
   /** clears all strings **/
   void clear();

   /** returns all strings as a list **/
   QStrList* data();

   /** sets the QStrList as new content of KStrListEdit **/
   void setData(QStrList *data);


   /** returns the index of the highlighted (main) Element **/
   unsigned int index();

   /** sets index as the highlighted (main) Element **/
   void setIndex(unsigned int index);


 protected:
   void resizeEvent(QResizeEvent *); 
   void paintEvent(QPaintEvent *ev); 
   void init();

 signals:
   void buttonUp();
   void buttonDown();
   void buttonTop();
   void buttonBottom();
   void buttonNewEntry();
   void buttonDelEntry();
   void returnPressed();
 
 public slots:

 private slots:
   void upSlot();
   void downSlot();
   void topSlot();
   void bottomSlot();
   void newSlot();
   void delSlot();
   void returnPressedSlot();
   void accKeyActivatedSlot(int k_id);

 private:
   KStdAccel    *stdAcc;
   QAccel       *qaccel;
   QStrList     *elems;
   unsigned int actIndex;

   QLabel       *upperElem;
   QGroupBox    *actElemBox;
   QLineEdit    *actElem;
   QLabel       *lowerElem;

   QPushButton  *upBtn, *downBtn, *topBtn, *bottomBtn
                ,*newBtn, *delBtn;

   int          upKey, downKey, topKey, bottomKey;
};

#endif  /* ifdef _HEISEDLG_H */
