/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program : kfstab
 * Authors : Andreas Reuter
 * E-Mail  : holtwick@uni-duisburg.de
 *           Andreas.Reuter@andreas-reuter.de
*****************************************************************************/

#ifndef _optpref_included
#define _optpref_included

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif  

#include <qcheckbox.h> // for checkboxes
#include <kwizard.h>

/**
 * This is class OptPreferences.
 * It handles users options selection 
 * and sends them back using signal newOption
 */
class OptPreferences : public KDialog
{
   Q_OBJECT
 public:
   /**
    * This is the constructor of class OptPreferences.
    *
    * It draws the widget, checks which options are activated and which
    * can be activated.
    */
   OptPreferences( QString optStr, QWidget *parent=0, QString name=0 );
 public slots:
   /**
    * Is called when defaults Checkbox is clicked
    * if its activated other options are disabled
    * if its deactivated other options are enabled
    */
   void defaultsClicked();
   /**
    * is called when the selected options are accepted
    * if defaults is activated its the only option,
    * otherwise the selected options are scanned and send to the input field
    */
   void optAccept();
 signals:
   /**
    * This signal is emitted whenever a new option is selected.
    */
   void newOptions( QString optionStr );
 private:
   QCheckBox   *QCBdefaults;
   QCheckBox   *QCBrw;
   QCheckBox   *QCBnoauto;
   QCheckBox   *QCBuser;
   QCheckBox   *QCBexec;
   QCheckBox   *QCBsuid;
   QCheckBox   *QCBdev;
   QCheckBox   *QCBsync;

   QPushButton   *QPBapply;
   QPushButton   *QPBcancel;
};

#endif

