/***************************************************************************
                          kduviewitem.h  -  description
                             -------------------
    begin                : Mon Jan 24 2000
    copyright            : (C) 2000 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDUVIEWITEM_H
#define KDUVIEWITEM_H

#include <qlistview.h>

//forward declaration of the Kdu classes
class KduView;
class KDuProcess;

/**Each KduViewItem represents one directory entry.
Attributes include the link-name and the "du" size.
Inherits from QListViewItem so that it can be used
inside KduView, which inherits from QListView.
  *@author David Beattie
  */

class KduViewItem : public QListViewItem  {
public: 
	KduViewItem(KduView *parent, char const *const name, int const size = -1);
	KduViewItem(KduViewItem *parent, char const *const name, int const size = -1);
	KduViewItem(KduViewItem *parent, KduViewItem *after, char const *const name,
	                                          int const size = -1);
	virtual ~KduViewItem();
  /**  */
  QString name(void) const;
  /** register (or unregister if dp is NULL) a DuProcess with this KduViewItem,
so that it will be killed when this item is deleted.
 */
  void setDuProcess(KDuProcess *dp);
  /** DuProcesses call this function to communicate
to this KduViewItem what the size of the directory
or file is as reported by "du". */
  void setSize(int size);
  /** adds or subtracts an amount from the listed
size of the directory or file.  Also propagates this change up the tree.*/
  void adjustSizeBy(int delta);
  /** returns the KDuProcess rooted at this
KduViewItem, if any. */
  KDuProcess *getDuProcess() const;
  /** returns whether the size of the item
is known.  If it is not, then surely, a
DuProcess is running to determine the
size. */
  bool isSizeUnknown(void) const;
  /** returns the "du"-computed directory or
file size as stored in this KduViewItem. */
  int size(void) const;
  /** typecasting function */
  KduViewItem *parent(void) const;
  /** typecasting function */
  KduViewItem *nextSibling(void) const;
  /** typecasting function */
  KduViewItem *firstChild(void) const;
  /** returns whether this item does not lie
within a closed subtree. */
  bool isVisible(void) const;
  /** display optimization: don't invalidate height
unless this item is open.  This will avoid
unnecessary "triggerUpdate" calls. */
  virtual void invalidateHeight(void);
  /** counteract display "optimization" of
"invalidateHeight".... if we're changing the
isOpen() status of the element, then we
really do need to invalidate the height,
no matter what. */
  virtual void setOpen(bool o);
  /**  */
  virtual const char * key(int column, bool) const;
private: // Private attributes
  /** file / directory name */
  QString linkname;
  /** tells whether this directory/file has not been given
      a size value yet. */
  bool sizeunknown;
  /** size of file / directory, calculated recursively
      using "du". */
  int dusize;
  /** If a "du" process is running wth this item
      at its root, it will set this variable, so
      if this item is deleted, the DuProcess will
      be killed as well. */
  KDuProcess *duprocess;
protected: // Protected methods
  /** translates a name, sizeunknown, size triplet
into displayable text */
  static QString computedText(char const *const name, bool const sizeunknown, int const size);
};

#endif
