/***************************************************************************
                          kduview.h  -  description
                             -------------------
    begin                : Wed Nov 24 11:21:57 EST 1999
    copyright            : (C) 1999 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDUVIEW_H
#define KDUVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qlistview.h>
class KDuProcess;

/** The KduView class provides the view widget for the KduApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KduView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KduApp class to manipulate and display
 * the document structure provided by the KduDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KduView : public QListView
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KduView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KduView();

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
  /** reimplemented for display optimization
purposes.  The default implementation in
QListView's source code (David Beattie:
"I checked source code versions 1.44 and
2.0 of qt") triggers two different kinds of
updates.  First, calling item->setOpen triggers
an update using triggerUpdate() if the item is
visible.  Second, QListView's setOpen adds
to that making the updated item "dirty", and
starting the dirtyItemTimer.  And because these
two kinds of updates are triggered in that order,
and thus the timers for them go off in that order
(so dirtyItemTimer's handler cannot sense that
the normal updateContents handler for triggerUpdate
has been run as well), then we get more updating
than we need. */
  virtual void setOpen(QListViewItem *item, bool open);

protected slots: // Protected slots
  /**  */
  void onItemSelect(QListViewItem *item);
  /**  */
  void onItemHighlight(QListViewItem *item);

public slots: // Public slots
  /** display optimization on resizeContents.
Calling update() is not always necessary
when resizing contents.  Only if resizing
the contents is going to be visually
apparant to the user. */
  void resizeContents(int w, int h);
};

#endif // KDUVIEW_H
