/***************************************************************************
                          kduprocess.cpp  -  description
                             -------------------
    begin                : Thu Nov 25 1999
    copyright            : (C) 1999 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kduprocess.h"
#include "kduview.h"
#include "kduviewitem.h"
#include "stdio.h"
#include <qfile.h>

KDuProcess::KDuProcess(KduViewItem *attachto):
	KProcess(),
	filesflag(FALSE),
	dirname(attachto->name()),
	guiIdleTimer(new QTimer(this)),
	treelistlevel(0),
	lastInserted(attachto),
	buffer(),
	bufferIO(buffer),
	bufferStream(&bufferIO),
	buffersize(0),
	dudirroot(""),
	ignoreUntilLevel(0),
	attachedto(attachto)
{
	bufferIO.open(IO_ReadWrite);

		/* want to be in containing directory for du of directory or file */
	KduViewItem *p = attachto->parent();
	while(p)
		dudirroot.prepend(p->name()), p = p->parent();

	connect(this,SIGNAL(receivedStdout(KProcess *, char *, int)),
	             SLOT(receiveStdout(KProcess *, char *, int)));
	connect(this,SIGNAL(receivedStderr(KProcess *, char *, int)),
	             SLOT(receiveStderr(KProcess *, char *, int)));
	connect(guiIdleTimer,SIGNAL(timeout()),
	                     SLOT(processStdout()));

	attachto->setDuProcess(this);
}

KDuProcess::~KDuProcess()
{
	attachedto->setDuProcess(0);
}

/** Gets the signals sent by "receivedStdout", copies the data into
 *  the buffer, so "processStdout" can read it and transform it into
 *  entries in a KTreeList at a convenient time.
 */
void KDuProcess::receiveStdout(KProcess *proc, char *input, int inplen)
{
	bufferIO.at(buffersize);
	bufferIO.writeBlock(input,inplen);
	buffersize += inplen;

	/* signal QT to process the buffer using "processStdout" when the GUI
     is idle */
	guiIdleTimer->start(0,FALSE);
}

/** process one line of the buffer */
void KDuProcess::processStdout(void)
{

	int linesize = buffer.find('\n') + 1;

	if ( !linesize || linesize > buffersize ) {
		guiIdleTimer->stop();
		if (!isRunning())
			delete this;
	} else {
		int dirdepth = 0;
		int dirsize;
		QString dirpath, dirpathbackup;
		char *dirpathpart;
		QString dirname; // = KDuProcess::dirname;

		bufferIO.at(0);
		bufferStream >> dirsize;
		dirpath = bufferStream.readLine();
		buffersize -= linesize;
		memmove(buffer.data(),buffer.data()+linesize,buffersize);

		/* because of the StreamIO used, the "tab" character may or may not be present
		   as the first character of dirpath.  We make sure one is there.  Then we use
		   this to our advantage in making sure the initial token of strtok is
		   not empty (strtok does not handle empty tokens--rather, it skips them) */

		if (dirpath[0] != '\t')
			dirpath.prepend("\t");

		/* now, we need a copy of the path for use in calls to "stat" */
		dirpathbackup = dirpath.data()+1;
		dirname = QString(strtok(dirpath.data(),"/")+1);
		for (dirpathpart=strtok(NULL,"/");dirpathpart;) {
			dirname = dirpathpart;
			++dirdepth;
			dirpathpart = strtok(NULL,"/");
			if (! ignoreUntilLevel)
				if (dirdepth == treelistlevel)
	        lastInserted = new KduViewItem(lastInserted->parent(),lastInserted,dirname+((!filesflag || dirpathpart || isDir(dirpathbackup)) ? "/" : ""));
				else if (dirdepth > treelistlevel)
					lastInserted = new KduViewItem(lastInserted,dirname+((!filesflag || dirpathpart || isDir(dirpathbackup)) ? "/" : ""));
		}

		if (! ignoreUntilLevel) {

			if (dirdepth > treelistlevel)
				treelistlevel = dirdepth;
			else if (dirdepth < treelistlevel)
				for (;
				     treelistlevel > dirdepth;
				     lastInserted = lastInserted->parent(), --treelistlevel);

			lastInserted->setSize(dirsize);

		} else if (dirdepth < ignoreUntilLevel) {
			treelistlevel = dirdepth;
			ignoreUntilLevel = 0;
			if (lastInserted->isSizeUnknown())
				lastInserted->setSize(dirsize);
			else
				if (lastInserted->parent())
					lastInserted->parent()->adjustSizeBy(lastInserted->size()-dirsize);
		}

	}
}

/** Begin a "du" scan on the directory specified in the KTreeListItem
that has been attached to. */
void KDuProcess::start(void)
{
	operator<<("du") << "-k";
	if (filesflag)
		operator<<("-a");
	operator<<(dirname);
	KProcess::start(NotifyOnExit,AllOutput);
}

/** Change directories before running the "du" command. */
int KDuProcess::commSetupDoneC(void)
{
	if (chdir(dudirroot+"/")) {  //hopefully, it has a leading '/' !!
		perror(dudirroot+"/");
		exit(1);
	}

	return KProcess::commSetupDoneC();
}

void KDuProcess::setShowFiles(bool show)
{
	filesflag = show;
}

bool KDuProcess::showFiles(void)
{
	return filesflag;
}

/**  */
void KDuProcess::receiveStderr(KProcess *proc, char *input, int inplen)
{
	QFile f;
	f.open(IO_WriteOnly,stderr);
	f.writeBlock(input,inplen);
	f.close();
}

/** Tells this KDuProcess that another KDuProcess
has been started, rooted at *item.  This function
must only be called when it is known that
this KDuProcess is currently processing a
part of the tree which is underneath *item,
because its effect will be to cause the output
of "du" to be ignored until it has progressed
past the point where it would modify *item. */
void KDuProcess::ignoreUntilAfter(KduViewItem *item)
{
	ignoreUntilLevel = item->depth() - attachedto->depth() + 1;
	lastInserted = item;
}

#include <sys/stat.h>
#include <unistd.h>

/**  */
bool KDuProcess::isDir(char const * const path)
{
	struct stat s;
	QString fullpath = dudirroot+path;
	if (lstat(fullpath,&s))
		perror(fullpath);
	return S_ISDIR(s.st_mode);
}
