/*
	pluginconfigedit.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include "pluginconfigedit.h"
#include "postprocess.h"
#include "util.h"

extern const char list_separator;

PluginConfigEdit::PluginConfigEdit(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	connect(pb_ok,SIGNAL(clicked()),SLOT(slotOk()));
	connect(pb_test,SIGNAL(clicked()),SLOT(slotTest()));
	connect(pb_select_file,SIGNAL(clicked()),SLOT(slotSelectFile()));
	connect(pb_cancel,SIGNAL(clicked()),SLOT(reject()));
	setCaption(i18n("Plugin setup"));
	sle_command->setFocus();
	cbx_on->setChecked(true);
}

PluginConfigEdit::~PluginConfigEdit(){
}

void PluginConfigEdit::slotOk()
{
	accept();
}

void PluginConfigEdit::slotTest()
{
	QString str;
	PluginClient* client=new PluginClient(sle_command->text());
	
	str=client->info();
	
	if (str == "")
	{
		KMsgBox::message(this,i18n("Message"),i18n("Unable to start the plugin or there is no response!"));
	}
	else
	{
		KMsgBox::message(this,i18n("ADE plugin test/info"),str);
	}

	delete client;
}

void PluginConfigEdit::slotSelectFile()
{
   QString ret;

   ret=KFileDialog::getOpenFileName((const char*) (kapp->kde_datadir()+"/kdiskcat/plugins"));
   if (!ret.isEmpty())
   {
      sle_command->setText(ret);
   	PluginClient* client=new PluginClient(sle_command->text());
      ret=client->defaults();
      delete client;
      sle_associated->setText(Util::cropFirstWord(&ret,list_separator));
      sle_fire->setText(Util::cropFirstWord(&ret,list_separator));
   };
}
