/*
	catsearch.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CATSEARCH_H
#define CATSEARCH_H

#include <qobject.h>
#include <qregexp.h>
#include <qstrlist.h>

#include "resultview.h"
#include "searchprogress.h"

class CatCriteria
{
public:
	QStrList categories;

	bool filename_on;
	bool description_on;
	QRegExp rexp;

	bool size_from_on;
	bool size_to_on;
	uint size_from;
	uint size_to;

	bool date_from_on;
	bool date_to_on;
	QDateTime date_from;
	QDateTime date_to;
	
/*   enum {STIP_FILENAME = 1,
   		STIP_DESCRIPTION = 2,
         STIP_SIZE = 4,
         STIP_DATE = 8};
*/
};

class CatSearch : public QObject
{
	Q_OBJECT
public:
	CatSearch(CatCriteria* pcrit);
	~CatSearch();
	void 					go();
protected:
	void 					searchBranch();
	CatCriteria*		crit;
	SearchProgress* 	dia_progress;
	ResultView*			dia_resultview;
	
	uint					total_scanned;
	uint					found;
	KPath					current_branch;
	bool					stopping_required;
protected slots:
	void					slotStop();
signals:
	void					categoryChangeRequired(int index);
};

#endif