/***************************************************************************
                          kdddllview.cpp  -  description                              
                             -------------------                                         

    version              : 1.0                                 
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qtextstream.h>
#include <qfile.h>

#include <klisttextodevice.h>
#include <kdddllview.h>
#include <kdddlldlg.h>
#include <kdddllparser.h>

KDDDLLView::KDDDLLView(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
  widget = new KEdit( KApplication::getKApplication(), this );
  widget->setWordWrap( false );
  widget->setReduceWhiteOnJustify( true );
  widget->setFillColumnMode( 0, false );
  connect( widget, SIGNAL( textChanged() ), this, SLOT( slotFileChanged() ) );
}

KDDDLLView::~KDDDLLView()
{
}

void KDDDLLView::previewFile()
{
    KDDDLLTagList *tagList = new KDDDLLTagList();

    KListTextODevice *dbglist = new KListTextODevice( 0, "Debug Messages" );
    dbglist->show();

    QString text = widget->text();
    QTextStream *in = new QTextStream( text, IO_ReadOnly );
    QTextStream *msgout = new QTextStream( dbglist );
    if( KDDDLLparse( tagList, in, msgout ) )
        if( !dbglist->count() )
            delete dbglist;
    delete in;

    if( tagList->isEmpty() )
    {
        KDEBUG( KDEBUG_ERROR, 1, "Either the parsed file is messed up or something went wrong" );
    }
    else
    {
        KDDDLLDlg *view = new KDDDLLDlg( tagList );
        view->show();
    }
    delete msgout;
    delete tagList;    
}

const char *KDDDLLView::getName()
{
    return widget->getName().data();
}

void KDDDLLView::resizeEvent(QResizeEvent *evt)
{
    QWidget::resizeEvent(evt);

    QRect r = this->geometry();
    widget->resize( r.width(), r.height() );
}

void KDDDLLView::slotEditCut()
{
    widget->cut();
    emit modifiedFile( true );
}

void KDDDLLView::slotEditCopy()
{
    widget->copyText();
}

void KDDDLLView::slotEditPaste()
{
    widget->paste();
    emit modifiedFile( true );
}

void KDDDLLView::slotOpenFile( const char * filename )
{
    QString file( filename );
    int done = widget->loadFile( file, KEdit::OPEN_READWRITE );
    emit modifiedFile( done != KEdit::KEDIT_OK );
    widget->setName( file.data() );
}

void KDDDLLView::slotSaveFile( const char * filename )
{
    QString file;
    if( !filename )
    {
        file = widget->getName();
    }
    else
        file = filename;
    int done = widget->doSave( file );
    emit modifiedFile( done != KEdit::KEDIT_OK );
    widget->setName( file.data() );
}

void KDDDLLView::slotSaveBinary( const char * filename )
{
    QFile *out = new QFile( filename );
    out->open( IO_WriteOnly );
    KDDDLLTagList *tagList = new KDDDLLTagList();
    KListTextODevice *dbglist = new KListTextODevice( 0, "Debug Messages" );
    dbglist->show();
    QString text = widget->text();
    QTextStream *in = new QTextStream( text, IO_ReadOnly );
    QTextStream *msgout = new QTextStream( dbglist );
    if( KDDDLLparse( tagList, in, msgout ) )
        delete dbglist;
    delete in;
    tagList->write( out );    
    out->close();
    delete out;
    delete tagList;
}

void KDDDLLView::slotPreviewBinary( const char * filename )
{
    QFile *in = new QFile( filename );
    if( !in->open( IO_ReadOnly ) )
    {
        delete in;
        return; // without comment
    }
    KDDDLLTagList *tagList = new KDDDLLTagList( in );
    in->close();
    delete in;

    if( tagList->isEmpty() )
    {
        KDEBUG( KDEBUG_ERROR, 1, "Either the parsed file is messed up or something went wrong" );
    }
    else
    {
        KDDDLLDlg *view = new KDDDLLDlg( tagList );
        view->show();
    }
    delete tagList;    
}

void KDDDLLView::slotFileChanged()
{
    emit modifiedFile( true );
}

