/*
 * pgpkey.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGPKEY_H
#define PGPKEY_H

#include "pgpsignature.h"
#include "pgpuserid.h"

#include <qlist.h>
#include <qdatetm.h>

const UINT8 PUBKEY_BASE      =   3;
const UINT8 PRIVKEY_BASE     =  20;
const UINT8 USERID_BASE      =  30;
const UINT8 SIGNATURE_BASE   =  40;

const UINT8 MENU_KEY_EXTRACT   =  PUBKEY_BASE + 0;

const UINT8 MENU_PUBKEY_EDIT      =  PUBKEY_BASE + 1;
const UINT8 MENU_PUBKEY_PAUSE     =  PUBKEY_BASE + 2;
const UINT8 MENU_PUBKEY_DELETE    =  PUBKEY_BASE + 3;
const UINT8 MENU_PUBKEY_CERT      =  PUBKEY_BASE + 4;

const UINT8 MENU_PRIVKEY_EDIT     =  PRIVKEY_BASE + 1;
const UINT8 MENU_PRIVKEY_REVOKE   =  PRIVKEY_BASE + 2;
const UINT8 MENU_PRIVKEY_DELETE   =  PRIVKEY_BASE + 3;
const UINT8 MENU_PRIVKEY_PASS     =  PRIVKEY_BASE + 4;
const UINT8 MENU_PRIVKEY_DEFAULT  =  PRIVKEY_BASE + 5;

const UINT8 MENU_USERID_DELETE    =  USERID_BASE + 0;
const UINT8 MENU_USERID_CERT      =  USERID_BASE + 1;

const UINT8 MENU_SIGNATURE_DELETE =  SIGNATURE_BASE + 0;

class PgpKey
{
public:
  
  static PgpKey*  getDefaultKey();

public:
  
  PgpKey(QDataStream &source, UINT8 ctb);
  virtual ~PgpKey();

  virtual void        store(QDataStream &dest) = 0;

  virtual void        setDefault(bool _default) = 0;
  virtual bool        isDefault();
  virtual void        setRevoked() = 0;
  virtual bool        isRevoked();
  virtual void        setPaused(bool paused) = 0;
  virtual bool        isPaused();
  virtual bool        isPrivate();

  virtual void        addRevocation(PgpSignature *sig);

  virtual void        insertUserId(PgpUserId *userId, int pos = -1);
  virtual PgpUserId*  newUserId(QString uid) = 0;

  virtual PgpUserId*  getUserId(int nr = 0);

  virtual bool        removeUserId(PgpUserId *userId);

  /** shouldnt be used (cs) */
  // virtual void        addMySignature(PgpSignature *mysig);

  virtual PgpSignature* sign(PgpKey *key) = 0;           // signs key->userId(0)

  virtual int         count();

  virtual void        extractKey(QString filename) = 0;

  /* returns a descrption of the key algorithm */
  virtual QString     algorithm() const = 0;

  /* returns version information of this key */
  virtual QString     format() const = 0;

  virtual QString     keyId() const = 0;
  virtual QString     fingerprint() = 0;
  virtual int         bitlen() = 0;
  virtual QDateTime   created() = 0;
  virtual int         getTrust() const = 0;
  virtual void        setTrust(int new_trust) = 0;

protected:
  
  static PgpKey        *defaultKey;     // points to the default private key

protected:
  
  bool                 is_default;
  bool                 is_revoked;
  bool                 is_private;
  bool                 is_paused;
  
  QList<PgpUserId>     *userId_list;
  // QList<PgpSignature>  *mySignature_list;
  QList<PgpSignature>  *revocation_list;
};

#endif
