/*
 * pgp2trust.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pgp2trust.h"
#include "pgp2key.h"

Pgp2Trust::Pgp2Trust(QDataStream &source, UINT8 &ctb) : 
  PgpTrust(),
  CTB(ctb)
{
  UINT8  len8;
  UINT16 len16;
  UINT32 len32;
  
  if (((ctb >> 2) & 15) != PGP2_TRUST)
    debug("Pgp2Trust::Constructor: no trust packet!");
  
  switch (CTB & 3)
    {
      case 0: source >> len8;   // 1 byte packet len
	      len = len8;
	      break;
      case 1: source >> len16;  // 2 byte packet len
	      len = len16;
	      break;
      case 2: source >> len32;  // 4 byte packet len
	      len = len32;
	      break;
      case 3: len = 0;      // unknown packet len
	      break;
    }
  
  source >> trust_byte;
};

Pgp2Trust::Pgp2Trust(const UINT8 tbyte) :
  CTB((PGP2_TRUST << 2) | 128)
{
  QString tmp;

  debug("Creating Pgp2Trust: " + tmp.setNum((int) CTB)); 

  len = 1;
  trust_byte = tbyte;
}

Pgp2Trust::~Pgp2Trust()
{};

void 
Pgp2Trust::store(QDataStream &dest)
{
  dest << CTB;
  
  switch (CTB & 3)
    {
      case 0: dest << (UINT8)  len;  // 1 byte packet len
	      break;
      case 1: dest << (UINT16) len;  // 2 byte packet len
	      break;
      case 2: dest << (UINT32) len;  // 4 byte packet len
	      break;
      case 3: len = 0;               // unknown packet len
	      break;
    }
  
  dest << trust_byte;
};


