#include <kwm.h>
#include <kcontrol.h>

#include "kbootselconfig.h"

/**
 * This is the class that implements the KControl Application.
 * Essentially the same as the KControlApplication of the KPanel
 * configuration (in the base package).
 *
 * @short The main class of the KControl Application
 * @author Stefan van den Oord <s.m.vandenoord@student.utwente.nl>
 * @version 0.3
 */
class KCMBootSel : public KControlApplication
{
public:

    KCMBootSel(int &argc, char **arg, const char *name);

    virtual void init();
    virtual void apply();
    virtual void help();
    virtual void defaultValues();

private:

    KBootSelConfig *kbootsel;
};

KCMBootSel::KCMBootSel(int &argc, char **argv,
				       const char *name)
    : KControlApplication(argc, argv, name)
{
    kbootsel = 0;

    if (runGUI())
	{
	    if (!pages || pages->contains("kcmbootsel"))
			addPage ( kbootsel = new KBootSelConfig(dialog, "kcmbootsel"),
			          i18n("&Boot Selector"), "kcmbootsel-1.html");
	
	    if ( kbootsel )
			dialog->show();
		else
		{
			fprintf(stderr, i18n("usage: kcmbootsel [-init]\n"));
			justInit = true;
		}
	}
}


void KCMBootSel::init() {}


void KCMBootSel::apply()
{
    if ( kbootsel )
		kbootsel->applySettings();
    QApplication::syncX();
}

void KCMBootSel::help()
{
	kapp->invokeHTMLHelp ( "kcontrol/kcmbootsel/kcmbootsel.html", "" );
}

void KCMBootSel::defaultValues()
{
	if ( kbootsel )
		kbootsel->defaultSettings();
}


int main(int argc, char **argv)
{
    KCMBootSel app(argc, argv, "kcmbootsel");

    app.setTitle ( QString ( CAPTION ) + QString (" ") + i18n ( "Configuration" ) );

    int ret;
    if (app.runGUI())
		ret = app.exec();
    else
		ret = 0;

    return ret;
}
