/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonstatus.cc,v 1.13 1999/01/15 06:08:49 russ Exp $
 *
 * $Log: kbatmonstatus.cc,v $
 * Revision 1.13  1999/01/15 06:08:49  russ
 * Added file headers.
 *
 *
 */
 
#include <kseparator.h>
#include <kprogress.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qkeycode.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

#include "kbatmon.h"
#include "kbatmonstatus.h"
#include "apmInterface.h"

KBatMonStatus::KBatMonStatus( APMInterface *pAPM, KBatMonConfig *pConfig )
    : QWidget(0), APM(pAPM)
{
    setCaption( i18n("KBatMon - Battery Status") );
    setMinimumSize( 300, 200 );

    QGroupBox *apm_info_group = new QGroupBox( i18n("APM Information"), this );
    
    QLabel *bios_version_label = new QLabel( i18n("BIOS Version : ")
                                 + APM->getAPMBIOSVersion(), apm_info_group  );

    QLabel *driver_version_label = new QLabel( i18n("Driver Version : ")
                                       + APM->getAPMDriverVersion(), apm_info_group );

    batLevelLabel = new QLabel( i18n("Battery Level"), this );
    
    batLevel = new KProgress( 0, 100, 0, KProgress::Horizontal, this );

    timeRemainingLabel = new QLabel(i18n("Battery Time Remaining"),
                                              this);
    timeRemaining = new QLabel( i18n("<unknown>"), this );

    QLabel *bat_status_label = new QLabel( i18n("Battery Status: "), this );
    batteryStatus = new QLabel( i18n("<none>"), this );
    batteryStatus->setAlignment(AlignLeft|AlignVCenter);
    batteryStatus->setFrameStyle(QFrame::Panel|QFrame::Sunken);

    QLabel *power_status_label = new QLabel( i18n("Power  Status: "), this );
    powerStatus = new QLabel( i18n("<none>"), this );
    powerStatus->setAlignment(AlignLeft|AlignVCenter);
    powerStatus->setFrameStyle(QFrame::Panel|QFrame::Sunken);

    connect( APM, SIGNAL(update()), this, SLOT(update()) );
    
    //--------------------------------------------------------------
    // Layout
    //--------------------------------------------------------------

    QBoxLayout *vert = new QVBoxLayout( this, 5  );

    batLevelLabel->setMinimumSize( batLevelLabel->sizeHint() );
    batLevelLabel->setMaximumHeight( batLevelLabel->sizeHint().height() );
    vert->addWidget( batLevelLabel, AlignLeft );

    batLevel->setMinimumHeight( batLevel->sizeHint().height() );
    vert->addWidget( batLevel );

    QBoxLayout *timeRow = new QHBoxLayout;

    vert->addLayout( timeRow );

    timeRemainingLabel->setFixedSize( timeRemainingLabel->sizeHint() );
    timeRow->addWidget( timeRemainingLabel );

    timeRemaining->setMinimumSize( timeRemaining->sizeHint() );
    timeRow->addWidget( timeRemaining );

    QBoxLayout *batRow = new QHBoxLayout;

    vert->addLayout( batRow );

    bat_status_label->setFixedSize( bat_status_label->sizeHint() );
    batRow->addWidget( bat_status_label );

    batteryStatus->setMinimumSize( batteryStatus->sizeHint() );
    batRow->addWidget( batteryStatus );

    QBoxLayout *powerRow = new QHBoxLayout;

    vert->addLayout( powerRow );

    power_status_label->setFixedSize( power_status_label->sizeHint() );
    powerRow->addWidget( power_status_label );
    
    powerStatus->setMinimumSize( powerStatus->sizeHint() );
    powerRow->addWidget( powerStatus );

    vert->addStretch( 1 );

    QBoxLayout *group_vert = new QVBoxLayout( apm_info_group, 5, 5 );
    QBoxLayout *group_horiz = new QHBoxLayout;
    group_vert->addSpacing( 15 );

    group_vert->addLayout( group_horiz );
    bios_version_label->setMinimumSize( bios_version_label->sizeHint() );
    group_horiz->addWidget( bios_version_label );

    driver_version_label->setMinimumSize( driver_version_label->sizeHint() );
    group_horiz->addWidget( driver_version_label );

    apm_info_group->setMinimumHeight( bios_version_label->sizeHint().height() + 40  );
    apm_info_group->adjustSize();

    vert->addWidget( apm_info_group );

    update();
    adjustSize();
}

void
KBatMonStatus::keyReleaseEvent( QKeyEvent *e )
{
   if( e->key() == Key_Escape ) {
      hide();
      e->accept();
   } else {
      e->ignore();
   }
}

void
KBatMonStatus::update()
{
    if( APM->haveBattery() )
    {
        batLevelLabel->show();
        batLevelLabel->setMinimumHeight( batLevelLabel->sizeHint().height() );

        batLevel->show();
        batLevel->setMinimumHeight( batLevel->sizeHint().height() );
        batLevel->setValue( APM->getBatteryPercentage() );

        timeRemainingLabel->show();
        timeRemainingLabel->setMinimumHeight( timeRemainingLabel->sizeHint().height() );
        
        timeRemaining->show();
        timeRemaining->setMinimumHeight( timeRemainingLabel->sizeHint().height() );

        QString timeString;

        timeString.sprintf("%d minutes", APM->getBatteryTime() );
        timeRemaining->setText(timeString);
    } else {
        batLevelLabel->hide();
        batLevelLabel->setMinimumHeight(0);
        batLevelLabel->resize(batLevelLabel->width(), 0);

        batLevel->hide();
        batLevel->setMinimumHeight(0);
        batLevel->resize(batLevelLabel->width(), 0);

        timeRemainingLabel->hide();
        timeRemainingLabel->setMinimumHeight(0);
        timeRemainingLabel->resize(timeRemainingLabel->width(), 0);

        timeRemaining->hide();
        timeRemaining->setMinimumHeight(0);
        timeRemaining->resize(timeRemaining->width(), 0);
    }

    batteryStatus->setText( APM->getBatteryStatusString() );
    powerStatus->setText( APM->getPowerStatusString() );
    
    resize(size());
}

