/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonapp.cc,v 1.2 1999/01/15 06:08:48 russ Exp $
 *
 * $Log: kbatmonapp.cc,v $
 * Revision 1.2  1999/01/15 06:08:48  russ
 * Added file headers.
 *
 *
 */
 
#include <qwidget.h>
#include <kapp.h>
#include <kglobalaccel.h>
#include <kwm.h>

#include "kbatmon.h"
#include "kbatmonapp.h"


KBatMonApp::KBatMonApp( int argc, char **argv ) : KApplication( argc, argv, "kbatmon" ), ga(false)
{
    mainWindow = new KBatMon;
    sessionProxy = new QWidget;
    setTopWidget( sessionProxy );

    ga.insertItem( i18n("Battery Status"), "Battery Status", "CTRL+ALT+B" );
    ga.connectItem( "Battery Status", mainWindow, SLOT(openStatusWindow()));
   
    ga.insertItem( i18n("Suspend"), "Suspend", "CTRL+ALT+S" );
    ga.connectItem( "Suspend", mainWindow, SLOT(suspend()) );
   
    ga.readSettings();
    
    mainWindow->show();
}

KBatMonApp::~KBatMonApp()
{
   ga.writeSettings();
   
   delete mainWindow;
   delete sessionProxy;
}

bool KBatMonApp::x11EventFilter( XEvent *ev )
{
   if( ga.x11EventFilter(ev) )
     return true;
   else 
     return false;
}
