/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmon.h,v 1.11 1999/01/15 06:08:48 russ Exp $
 *
 * $Log: kbatmon.h,v $
 * Revision 1.11  1999/01/15 06:08:48  russ
 * Added file headers.
 *
 *
 */
 
#ifndef _KBATMON_H_
#define _KBATMON_H_

#include <qwidget.h>

#include "kbatmonstatus.h"
#include "kbatmonconfig.h"
#include "apmInterface.h"

class QPopupMenu;

class KBatMon : public QWidget
{
    Q_OBJECT

public:
    KBatMon();
    virtual ~KBatMon();

    // Menu Item IDs
   
    enum {
        Status_ID,
        Config_ID,
        Suspend_ID,
        Standby_ID,
        Help_ID,
        About_ID,
        Exit_ID
    };

protected:
    void mousePressEvent( QMouseEvent* );
    void paintEvent( QPaintEvent* );

public slots:
    void openStatusWindow();
    void openConfigDialog();
   
    void suspend();
    
private slots:
    void apmUpdate();
    void dockInPanelChanged(bool);
    void shutdown();
    void help();
    void about();

private:
    KBatMonConfig config;
    APMInterface *APM;
    QPopupMenu *popup;
    KBatMonStatus *status_dlg;
};


#endif  /* _KBATMON_H_ */
