#include <qevent.h>

#include "display.h"

#include "display/dback.xpm"
#include "display/ddial_on.xpm"
#include "display/ddial_off.xpm"
#include "display/donline_on.xpm"
#include "display/donline_off.xpm"
#include "display/drx_on.xpm"
#include "display/drx_off.xpm"
#include "display/dtx_on.xpm"
#include "display/dtx_off.xpm"


MyDisplay::MyDisplay(QWidget *parent, const char *name):QLabel(parent, name)
{
  back = QPixmap(dback_xpm);
  
  dial = QPixmap(ddial_off_xpm);
  bitBlt(&back, 15, 1, &dial, 0, 0, 7, 7, CopyROP);
  onl = QPixmap(donline_off_xpm);
  bitBlt(&back, 2, 16, &onl, 0, 0, 7, 7, CopyROP, true);
  rec = QPixmap(drx_off_xpm);
  bitBlt(&back, 1, 1, &rec, 0, 0, 12, 13, CopyROP, true);
  trans = QPixmap(dtx_off_xpm);
  bitBlt(&back, 11, 10, &trans, 0, 0, 12, 13, CopyROP, true);
 
  setPixmap(back);
  resize(24, 24);
  
  dialing      = false;
  online       = false;
  receiving    = false;
  transmitting = false;
}


void MyDisplay::setDial(void)
{
  dial = QPixmap(ddial_on_xpm);
  bitBlt(&back, 15, 1, &dial, 0, 0, 7, 7, CopyROP);
  setPixmap(back);
  dialing = true;
}


void MyDisplay::clearDial(void)
{
  dial = QPixmap(ddial_off_xpm);
  bitBlt(&back, 15, 1, &dial, 0, 0, 7, 7, CopyROP);
  setPixmap(back);
  dialing = false;
}

 
void MyDisplay::setOnline(void)
{
  onl = QPixmap(donline_on_xpm);
  bitBlt(&back, 2, 16, &onl, 0, 0, 7, 7, CopyROP);
  setPixmap(back);
  online = true;
}


void MyDisplay::clearOnline(void)
{
  onl = QPixmap(donline_off_xpm);
  bitBlt(&back, 2, 16, &onl, 0, 0, 7, 7, CopyROP);
  setPixmap(back);
  online = false;
} 
  
  
void MyDisplay::setReceive(void)
{
  rec = QPixmap(drx_on_xpm);
  bitBlt(&back, 1, 1, &rec, 0, 0, 12, 13, CopyROP);
  setPixmap(back);
  receiving = true;
}


void MyDisplay::clearReceive(void)
{
  rec = QPixmap(drx_off_xpm);
  bitBlt(&back, 1, 1, &rec, 0, 0, 12, 13, CopyROP);
  setPixmap(back);
  receiving = false;
}  
  
  
void MyDisplay::setTransmit(void)
{
  trans = QPixmap(dtx_on_xpm);
  bitBlt(&back, 11, 10, &trans, 0, 0, 12, 13, CopyROP);
  setPixmap(back);
  transmitting = true;
}


void MyDisplay::clearTransmit(void)
{
  trans = QPixmap(dtx_off_xpm);
  bitBlt(&back, 11, 10, &trans, 0, 0, 12, 13, CopyROP);
  setPixmap(back);
  transmitting = false;
}   


void MyDisplay::mousePressEvent(QMouseEvent *event)
{
  switch (event->button())
  {
    case LeftButton : emit leftClick();    
                      break;
    case RightButton: emit rightClick();          
  }
}
