#include "prefdlg.h"
#include "pixmaps/magnify.xpm"


AdvancedDialog::AdvancedDialog(QWidget *parent, const char *name):QDialog(parent, name, true)
{
  char      buffer[8];
  AdvData   *adv = &((ISDNData.General)->Advanced);
  
  setMinimumSize(400, 180);
  setMaximumSize(400, 180);
  setCaption(klocale->translate("Advanced Options"));

  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 380, 126);
  GBox->setTitle(klocale->translate("ipppd Options"));
  
  pmMagnify = new QLabel(this);
  pmMagnify->setPixmap(magnify_xpm);
  pmMagnify->setGeometry(340, 35, 26, 27);
  
  Bsdcheck = new QCheckBox(klocale->translate("Disable BSD Compression"), this);
  Bsdcheck->adjustSize();
  Bsdcheck->setGeometry(30, 40, Bsdcheck->width(), Bsdcheck->height() );
  Bsdcheck->setChecked(adv->bsdcomp);
  connect(Bsdcheck, SIGNAL(clicked()), SLOT(slotBSDCompChanged()));

  Dbgcheck = new QCheckBox(klocale->translate("Increase debugging level"), this);
  Dbgcheck->adjustSize();
  Dbgcheck->setGeometry(30, 64, Dbgcheck->width(), Dbgcheck->height() );
  Dbgcheck->setChecked(adv->incdebug);
  connect(Dbgcheck, SIGNAL(clicked()), SLOT(slotIncDebugChanged()));

  Dbglevellabel = new QLabel("Kernel Debugging Level:", this);
  Dbglevellabel->setGeometry(30, 98, 150, 24);
  
  Debuglevel = new QLineEdit(this);
  Debuglevel->setGeometry(190, 98, 40, 24);
  sprintf(buffer, "%i", adv->dbglevel);
  Debuglevel->setText(buffer);
  
  Ok = new QPushButton(klocale->translate("Ok"), this);
  Ok->setGeometry(222, 144, 80, 28);
  Ok->setDefault(true);
  connect(Ok, SIGNAL(clicked()), SLOT(accept()));

  Cancel = new QPushButton(klocale->translate("Cancel"), this);
  Cancel->setGeometry(310, 144, 80, 28);
  connect(Cancel, SIGNAL(clicked()), SLOT(reject()));
}


void AdvancedDialog::slotBSDCompChanged(void)
{
  (ISDNData.General)->Advanced.bsdcomp = Bsdcheck->isChecked();
}


void AdvancedDialog::slotIncDebugChanged(void)
{
  (ISDNData.General)->Advanced.incdebug = Dbgcheck->isChecked();
}

