#include "Logging.moc"
#include "AddRCPT.h"
#include <qlabel.h>
#include <kapp.h>
#include <klocale.h>

Logging::Logging(QWidget *parent=0, const char *name=0): QWidget(parent,name)
{
	int x=5, y=0;
	int w=640, h=380;
	ftpxs=0;

	int afterLogX, anonX, guestX, realX, mailX, mailLBX;
	int cmdY, tfY, secY;

	QLabel *lbl1=new QLabel(i18n("Log commands:"), this);
	cmdY=y;	lbl1->move(x,cmdY);
	lbl1->resize(lbl1->sizeHint().width(),lbl1->height());
	y+=lbl1->height();
	afterLogX=lbl1->width();
	QLabel *lbl2=new QLabel(i18n("Log transfers:"), this);
	tfY=y; lbl2->move(x,tfY);
	lbl2->resize(lbl2->sizeHint().width(),lbl2->height());
	y+=lbl2->height();
	QLabel *lbl3=new QLabel(i18n("Inbound:"), this);
	y+=lbl3->height();
	QLabel *lbl4=new QLabel(i18n("Outbound:"), this);
	QLabel *lbl5=new QLabel(i18n("Security log:"), this);
	secY=y; lbl5->move(x,secY);
	lbl5->resize(lbl5->sizeHint().width(),lbl5->height());
	y+=lbl5->height();
	if(lbl5->width()>afterLogX)
		afterLogX=lbl5->width();
	afterLogX+=5;
	if(lbl3->width()<lbl4->width())
		anonX=afterLogX+lbl4->width()+5;
	else
		anonX=afterLogX+lbl3->width()+5;
	lbl3->move(afterLogX,tfY);
	lbl4->move(afterLogX,tfY+lbl3->height());
	
	logCommandsAnon=new QCheckBox(i18n("A&nonymous"),this);
	logCommandsAnon->move(anonX,cmdY);
	guestX=anonX+5+logCommandsAnon->width();
	logCommandsGuest=new QCheckBox(i18n("&Guest"),this);
	logCommandsGuest->move(guestX,cmdY);
	realX=guestX+5+logCommandsGuest->width();
	logCommandsReal=new QCheckBox(i18n("&Real"),this);
	logCommandsReal->move(realX,cmdY);
	y=tfY;
	logTransfersAnonIn=new QCheckBox(i18n("An&onymous"),this);
	logTransfersAnonIn->move(anonX,y);
	logTransfersGuestIn=new QCheckBox(i18n("G&uest"),this);
	logTransfersGuestIn->move(guestX,y);
	logTransfersRealIn=new QCheckBox(i18n("R&eal"),this);
	logTransfersRealIn->move(realX,y);
	y+=lbl3->height();
	logTransfersAnonOut=new QCheckBox(i18n("Anon&ymous"),this);
	logTransfersAnonOut->move(anonX,y);
	logTransfersGuestOut=new QCheckBox(i18n("Gue&st"),this);
	logTransfersGuestOut->move(guestX,y);
	logTransfersRealOut=new QCheckBox(i18n("Re&al"),this);
	logTransfersRealOut->move(realX,y);
	logSecurityAnon=new QCheckBox(i18n("Anony&mous"),this);
	logSecurityAnon->move(anonX,secY);
	logSecurityGuest=new QCheckBox(i18n("Gues&t"),this);
	logSecurityGuest->move(guestX,secY);
	logSecurityReal=new QCheckBox(i18n("Rea&l"),this);
	logSecurityReal->move(realX,secY);
	logSyslog=new QCheckBox(i18n("Redirect lo&g to syslog"),this);
	logSyslog->move(x,secY+lbl5->height());
	logSyslog->resize(logSyslog->sizeHint().width(),logSyslog->height());
	x=5;y=logSyslog->y()+logSyslog->height();
	mailAdmin=new QCheckBox(i18n("E-&mail ftpadmin on uploads:"),this);
	mailAdmin->setGeometry(x,y,mailAdmin->sizeHint().width(),mailAdmin->height());
	connect(mailAdmin,SIGNAL(clicked()),SLOT(mailAdminPressed()));
	mailX=x+mailAdmin->width();
	mailFrom=new InputCtl(i18n("&Send mail as"),0,this);
	mailFrom->setGeometry(mailX,y,w-mailX-5,mailFrom->height()); y+=mailFrom->height();
	mailServer=new InputCtl(i18n("Mail ser&ver"),0,this);
	mailServer->setGeometry(mailX,y,w-mailX-5,mailFrom->height()); y+=mailServer->height();
	QLabel *lbl6=new QLabel(i18n("&Send mail to:"),this);
	mailRecipients=new QListBox(this); lbl6->setBuddy(mailRecipients);
	lbl6->setGeometry(mailX,y,lbl6->sizeHint().width(),lbl6->height());
	mailLBX=mailX+lbl6->width();
	mailRecipients->setGeometry(mailLBX,y,w-mailLBX-5,h-y-3*lbl6->height());
	y+=mailRecipients->height();
	addRecipient=new QPushButton(i18n("&Add"),this);
	addRecipient->setGeometry(mailLBX,y,(w-mailLBX-5)/2,addRecipient->height());
	connect(addRecipient,SIGNAL(clicked()),SLOT(addRecipientPressed()));
	rmRecipient=new QPushButton(i18n("&Remove"),this);
	rmRecipient->setGeometry(mailLBX+(w-mailLBX-5)/2,y,(w-mailLBX-5)/2,rmRecipient->height());
	connect(rmRecipient,SIGNAL(clicked()),SLOT(rmRecipientPressed()));
	mailAdminPressed();
}
Logging::~Logging()
{
}
void Logging::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	logSyslog->setChecked(ftpxs->getLogSyslog());
	logCommandsAnon->setChecked((ftpxs->getLogCommands()&ANONYMOUS)!=0);
	logCommandsGuest->setChecked((ftpxs->getLogCommands()&GUEST)!=0);
	logCommandsReal->setChecked((ftpxs->getLogCommands()&REAL)!=0);
	logSecurityAnon->setChecked((ftpxs->getLogSecurity()&ANONYMOUS)!=0);
	logSecurityGuest->setChecked((ftpxs->getLogSecurity()&GUEST)!=0);
	logSecurityReal->setChecked((ftpxs->getLogSecurity()&REAL)!=0);
	logTransfersAnonIn->setChecked((ftpxs->getLogTransfers()&ANONYMOUS)!=0);
	logTransfersGuestIn->setChecked((ftpxs->getLogTransfers()&GUEST)!=0);
	logTransfersRealIn->setChecked((ftpxs->getLogTransfers()&REAL)!=0);
	logTransfersAnonOut->setChecked((ftpxs->getLogTransfers()&ANONYMOUS_OUT)!=0);
	logTransfersGuestOut->setChecked((ftpxs->getLogTransfers()&GUEST_OUT)!=0);
	logTransfersRealOut->setChecked((ftpxs->getLogTransfers()&REAL_OUT)!=0);
	mailAdmin->setChecked(ftpxs->getMailAdmin());
	mailFrom->setText(ftpxs->getMailFrom());
	mailServer->setText(ftpxs->getMailServer());
	mailAdminPressed();
	redraw();
}
void Logging::mailAdminPressed()
{
	mailFrom->setEnabled(mailAdmin->isChecked());
	mailServer->setEnabled(mailAdmin->isChecked());
	mailRecipients->setEnabled(mailAdmin->isChecked());
	addRecipient->setEnabled(mailAdmin->isChecked());
	rmRecipient->setEnabled(mailAdmin->isChecked());
}
void Logging::addRecipientPressed()
{
	AddRCPT *a=new AddRCPT;
	connect(a,SIGNAL(RCPTAdded(char *)),SLOT(RCPTAdded(char *)));
}
void Logging::rmRecipientPressed()
{
	for(unsigned int i=0;i<mailRecipients->count();i++)
		if(mailRecipients->isSelected(i)) {
			mailRecipients->removeItem(i);
			ftpxs->getMailRecipients()->remove(i);
		}
}
void Logging::RCPTAdded(char *rcpt)
{
	mailRecipients->insertItem(rcpt);
	ftpxs->getMailRecipients()->append(rcpt);
}
void Logging::redraw()
{
	mailRecipients->setAutoUpdate(false);
	mailRecipients->clear();
	QStrList *l=ftpxs->getMailRecipients();
	char *r=l->first();
	while(r) {
		mailRecipients->insertItem(r);
		r=l->next();
	}
	mailRecipients->setAutoUpdate(true);
	mailRecipients->update();
}
void Logging::update()
{
	ftpxs->setLogSyslog(logSyslog->isChecked());
	ftpxs->setLogCommands(ANONYMOUS*logCommandsAnon->isChecked()+GUEST*logCommandsGuest->isChecked()+REAL*logCommandsReal->isChecked());
	ftpxs->setLogSecurity(ANONYMOUS*logSecurityAnon->isChecked()+GUEST*logSecurityGuest->isChecked()+REAL*logSecurityReal->isChecked());
	ftpxs->setLogTransfers(ANONYMOUS*logTransfersAnonIn->isChecked()+GUEST*logTransfersGuestIn->isChecked()+REAL*logTransfersRealIn->isChecked()+ANONYMOUS_OUT*logTransfersAnonOut->isChecked()+GUEST_OUT*logTransfersGuestOut->isChecked()+REAL_OUT*logTransfersRealOut->isChecked());
	ftpxs->setMailAdmin(mailAdmin->isChecked());
	if(mailAdmin->isChecked()) {
		ftpxs->setMailFrom((char *)mailFrom->text());
		ftpxs->setMailServer((char *)mailServer->text());
	}
}
