
#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <qwidget.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qbitmap.h>
#include <qscrollview.h>

static const int HeaderHeight = 20;


// Struktur eines LV-Items

struct listItem{
				int	kennung;
				// text der Spalten
				QString 	*text[99];	// mehr wie 99 Spalten werden wohl nicht vorkommen !
				QPixmap 	*listviewIcon;
				bool	   selected;
				bool		hasFocus;
				struct 	listItem *prev;				
				struct 	listItem *next;				
			} ;


class listView : public QWidget  {
   Q_OBJECT
public: 
	listView(int x,int y,int b,int h,QWidget *parent=0, const char *name=0);
	struct listItem * 	Liste;
	struct listItem * lastItemClicked;
	struct listItem * mouseOverItem;
	int 						itemCount;
	void 						refreshListview();
	void						setColums(int colums);
	void						setColumWidth(int columnum,int width);
	void						setColumText(int columnum,QString text);
	
// eigentliche Listview-Funktionen
	void					clear();								// komplette Liste lschen
	struct listItem * addItem();							// erzeugt neues Item und gibt Zeiger auf
																	// dieses zurck
	void					delItem(struct listItem *);   // lscht das bergebene Item aus der Liste
	void					setSortOrder(bool);				// true = abwaerts  false = aufwaerts
	void					setSortColum(int);				// nach welcher Spalte wird sortiert ?
  void					setItemText(struct listItem *,int,const char * );
  void					readDir(const char *);
  int						itemsSelected();
	void  				setItemFocus(listItem *li);
   	
// public Variablen
	QColor	backgroundColor;
	QColor	selBackgroundColor;
	QColor	forgroundColor;
	QColor	selForgroundColor;
	bool		cursorFilled;
	QColor	cursorColor;
	QColor	cursorColorSelected;
	QColor	cursorTextColor;
	QColor	cursorTextColorSelected;
	QColor	cursorRand;
	
	bool		listHasFocus;
	struct listItem * getItemFocus();
   QPixmap *foldericon;
   QPixmap *fileicon;
   QPixmap *linkicon;
   QPixmap *folderlinkicon;
   QPixmap *upicon;
	
	
	int					columWidth[99];		// max 99 spalten
	void				refreshColums(int);
	QString			dirPath;
	int					colums;
		
	~listView();

private:
	listItem		*shiftItem;
	QPainter		*p;
	QScrollBar	*scroll1,*scroll2;
	void				init();
	QString 		columText[99];		// max 99 spalten
	bool				sortOrder;
	//nach welcher Spalte sortiert wird
	int					sortButton;
	bool				mausGedrueckt;
	int					schiebeSpalte;
	void				drawArrow();
	void				sortList();
	QWidget 		*mainWindow;
			
   int			mouseX,mouseY,oldMouseX,oldMouseY;
	QBitmap 		*c0_bitmap;
	QBitmap 		*c0_mask;
	QCursor 		*cursor0;
	QCursor 		*cursor1;
	QCursor 		*cursor2;
	
	
   bool		mustUpdate;		// alle 200 Zyclen wird flag abgefragt, wenn TRUE,
   								// wird ListView geupdatet...spart enorm Zeit !
   bool		updateReady;	// es wird erst geupdated wenn updateready = true

   bool		selectItems;
   int		richtung;
   struct listItem *firstItemClicked;


	struct listItem * firstVisibleItem;
	struct listItem * lastVisibleItem;
	int					maxVisibleItems;

   				
	void	drawItem(struct listItem *,int y);

void Rechteck(QPainter *p,int x,
								  int y,
								  int b,
								  int h,
								  long farbe,
								  bool gedrueckt,
								  bool flat
								  );


protected:
	void paintEvent ( QPaintEvent * );
	void mouseMoveEvent (QMouseEvent *);
	void mousePressEvent (QMouseEvent *);
	void mouseReleaseEvent (QMouseEvent *);
	void resizeEvent ( QResizeEvent * );

private slots:
  void 	timerEvent(QTimerEvent *t);
	void 	hScrollChanged(int);
	void 	vScrollChanged(int);
	void	btClicked();
 	void	focusInEvent ( QFocusEvent * );
 	void	focusOutEvent ( QFocusEvent * );
 	void	keyPressEvent ( QKeyEvent * e );
 	void	keyReleaseEvent ( QKeyEvent * e );
 	void	mouseDoubleClickEvent ( QMouseEvent * );

signals:
	void	itemSelected(const char *, const char *);
	void	itemDeSelected(const char *, const char *);
	void	itemClicked(const char *, const char *);
	void	itemDoubleClicked(const char *, const char *);
	void	columsChanged();
	void	gotFocus();			
	void	lostFocus();			
	void	keyPressed(const char *);
};

#endif
















