#include "dlgoptions.h"
#include <qpixmap.h>
#include "back.xpm"
#include <qpushbutton.h>
#include <kapp.h>
#include <qfont.h>

dlgOptions::dlgOptions(listView *l1,listView *l2, QWidget *parent,int defaultPage, const char *name ) : QTabDialog(parent,name,true)
{
	

	setCaption(i18n("KCommander Options Menu"));
	setOKButton(i18n("&OK"));
	setApplyButton(i18n("&Apply"));
	setCancelButton(i18n("&Cancel"));
/*
	QWidget *page;
	switch (defaultPage)
	{
		case 0:	page = seite3;
		case 1:	page = seite2;
		case 2:	page = seite3;
		case 3:	page = seite4;
		default:	page = seite1;
	}
*/	
	// showPage(QWidget *) w1	<----- wieso geht das nicht ????
	
	lv1 = l1;
	lv2 = l2;
	QLabel *text;
	setBackgroundPixmap ( QPixmap((const char **)back) );
	resize(500,400);
  tab = this;
	
// ***************   ERSTE TABSEITE ******************************
	QLabel *l1;
	seite1 = new QWidget( tab, "page one" );

	// stuff the labels and lineedits into a grid layout
	QGridLayout * g = new QGridLayout( seite1, 15, 15, 10);

	l1 = new QLabel(i18n("Background, not selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 0, 1 );
	
	l1 = new QLabel(i18n("Background, selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 1, 1 );
	
	l1 = new QLabel(i18n("Text, not selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 2, 1 );
	
	l1 = new QLabel(i18n("Text, selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 3, 1 );

	
	cb1 = new KColorButton(seite1);
	cb1->setColor(lv1->backgroundColor);
	cb1->setMinimumSize(QSize(50,20));
	cb1->setMaximumSize(QSize(50,20));
	g->addWidget(cb1,0,2);
		
	cb2 = new KColorButton(seite1);
	cb2->setColor(lv1->selBackgroundColor);
	cb2->setMinimumSize(QSize(50,20));
	cb2->setMaximumSize(QSize(50,20));
	g->addWidget(cb2,1,2);
		
	cb3 = new KColorButton(seite1);
	cb3->setColor(lv1->forgroundColor);
	cb3->setMinimumSize(QSize(50,20));
	cb3->setMaximumSize(QSize(50,20));
	g->addWidget(cb3,2,2);
		
	cb4 = new KColorButton(seite1);
	cb4->setColor(lv1->selForgroundColor);
	cb4->setMinimumSize(QSize(50,20));
	cb4->setMaximumSize(QSize(50,20));
	g->addWidget(cb4,3,2);
		
	cb9 = new KColorButton(seite1);
	cb9->setColor(lv1->cursorRand);
	cb9->setMinimumSize(QSize(50,20));
	cb9->setMaximumSize(QSize(50,20));
	g->addWidget(cb9,4,2);
		
	
	
	l1 = new QLabel(i18n("Full Cursor"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 5, 1 );
  
  cf = new QCheckBox(seite1);
  cf->setChecked(lv1->cursorFilled);
	connect(cf,SIGNAL(clicked()),this,SLOT(filledClicked()));
	g->addWidget( cf, 5, 2 );
 
	l1 = new QLabel(i18n("Cursorbackground, not selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 6, 1 );
	
	l1 = new QLabel(i18n("Cursorbackground, selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 7, 1 );
	
	l1 = new QLabel(i18n("Cursortext, not selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 8, 1 );
	
	l1 = new QLabel(i18n("Cursortext, selected"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 9, 1 );
	
	l1 = new QLabel(i18n("Cursorborder"),seite1);
	l1->setMinimumSize( QSize( 200, 10 ) );
	g->addWidget( l1, 4, 1 );
	
	cb5 = new KColorButton(seite1);
	cb5->setColor(lv1->cursorColor);
	cb5->setMinimumSize(QSize(50,20));
	cb5->setMaximumSize(QSize(50,20));
	g->addWidget(cb5,6,3);
		
	cb6 = new KColorButton(seite1);
	cb6->setColor(lv1->cursorColorSelected);
	cb6->setMinimumSize(QSize(50,20));
	cb6->setMaximumSize(QSize(50,20));
	g->addWidget(cb6,7,3);
		
	cb7 = new KColorButton(seite1);
	cb7->setColor(lv1->cursorTextColor);
	cb7->setMinimumSize(QSize(50,20));
	cb7->setMaximumSize(QSize(50,20));
	g->addWidget(cb7,8,3);
	
	cb8 = new KColorButton(seite1);
	cb8->setColor(lv1->cursorTextColorSelected);
	cb8->setMinimumSize(QSize(50,20));
	cb8->setMaximumSize(QSize(50,20));
	g->addWidget(cb8,9,3);
	
	
	// finally insert page one into the tab dialog and start GM
	tab->addTab( seite1, i18n("&Colors") );
	g->activate();
	filledClicked();
	
// ***************   ZWEITE TABSEITE ******************************
// *                Packeroptionen
// ****************************************************************

seite2 = new QWidget( tab, "packer konfigurieren" );

text = new QLabel(i18n("Methode Of Packer"),seite2);
text->setGeometry(30,30,text->sizeHint().width(),20);

// fill the leftmost vertical box
b1 = new QRadioButton( seite2, "0" );
b1->setText( i18n("cpmpress normal") );
b1->setMinimumSize( b1->sizeHint() );
b1->setMaximumSize( 500, b1->minimumSize().height() );
b1->setGeometry(50,50,200,10);

b2 = new QRadioButton( seite2, "1" );
b2->setText( i18n("Compress At Background") );
b2->setMinimumSize( b2->sizeHint() );
b2->setMaximumSize( 500, b2->minimumSize().height() );
b2->setGeometry(50,70,200,10);

b3 = new QRadioButton( seite2, "2" );
b3->setText( i18n("Ask Me Before Starting Compress !") );
b3->setMinimumSize( b3->sizeHint() );
b3->setMaximumSize( 500, b3->minimumSize().height() );
b3->setGeometry(50,90,200,10);

b2->setChecked(true);
text = new QLabel(i18n("Packroutine"),seite2);
text->setGeometry(30,120,text->sizeHint().width(),20);

// fill the leftmost vertical box
b4 = new QRadioButton( seite2, "3" );
b4->setText( i18n("GZIP-Filter") );
b4->setMinimumSize( b4->sizeHint() );
b4->setMaximumSize( 500, b4->minimumSize().height() );
b4->setGeometry(50,140,200,10);

b5 = new QRadioButton( seite2, "4" );
b5->setText( i18n("BZ2-Filter") );
b5->setMinimumSize( b5->sizeHint() );
b5->setMaximumSize( 500, b5->minimumSize().height() );
b5->setGeometry(50,160,200,10);

// insert all of the radio boxes into the button group, so they'll
// switch each other off
bg = new QButtonGroup();
bg2 = new QButtonGroup();

bg->insert( b1 );
bg->insert( b2 );
bg->insert( b3 );

bg2->insert( b4 );
bg2->insert( b5 );
	
// add some optional spacing between the radio buttons and the slider

tab->addTab( seite2, i18n("&Packer Configuration") );

// ***************   DRITTE TABSEITE Sicherheitsabfragen ******************************
	seite3 = new QWidget( tab, "page three" );

	// stuff the labels and lineedits into a grid layout
	
	l1 = new QLabel(i18n("Should I Ask You If :"),seite3);
	l1->setFont(QFont("Helvetica", 14, QFont::Bold));
	l1->setGeometry(QRect(QPoint(10,20),l1->sizeHint()));
	
	cf1 = new QCheckBox(i18n("Delete Files"),seite3);
	cf1->setFont(QFont("Helvetica", 14));
	cf1->setGeometry(QRect(QPoint(10,60),cf1->sizeHint()));
	cf1->setChecked(optionen::askDelete());
	
	cf2 = new QCheckBox(i18n("Overwrite Files"),seite3);
	cf2->setFont(QFont("Helvetica", 14));
	cf2->setGeometry(QRect(QPoint(10,80),cf2->sizeHint()));
	cf2->setChecked(optionen::askOverwrite());
	
	cf3 = new QCheckBox(i18n("Exiting KCommander"),seite3);
	cf3->setFont(QFont("Helvetica", 14));
	cf3->setGeometry(QRect(QPoint(10,100),cf3->sizeHint()));
	cf3->setChecked(optionen::askExit());
	
		
	// finally insert page one into the tab dialog and start GM
	tab->addTab( seite3, i18n("&Security Questions") );
	
// ***************   VIERTE TABSEITE ******************************

	seite4 = new QWidget( tab, "page three" );

	// stuff the labels and lineedits into a grid layout
	
	l1 = new QLabel(i18n("Configuration Mimetypes"),seite4);
	l1->setFont(QFont("Helvetica", 14, QFont::Bold));
	l1->setGeometry(QRect(QPoint(10,20),l1->sizeHint()));
	
	
	l1 = new QLabel(i18n("Mimetypes"),seite4);
	l1->setFont(QFont("Helvetica", 14));
	l1->setGeometry(QRect(QPoint(10,60),l1->sizeHint()));

	mimeList = new QListBox(seite4);
  	mimeList->setGeometry(10,80,260,200);
	mimeProgList = new QListBox(seite4);
  	mimeProgList->setGeometry(280,120,260,200);
  	mimeProgList->hide();
  	
  	connect(mimeList,SIGNAL(highlighted(int)),this,SLOT(mimeTypeClicked(int)));

	mimeButtonNew		= new QPushButton(i18n("&New"),seite4);
	mimeButtonNew->setGeometry(10,290,80,20);
	mimeButtonDelete  = new QPushButton(i18n("&Remove"),seite4);
	mimeButtonDelete->setGeometry(190,290,80,20);
	mimeButtonDelete->setEnabled(false);
	mimeDirButton = new QPushButton(i18n("&Browse"),seite4);
	mimeDirButton->setGeometry(390,130,80,20);
	mimeDirButton->setEnabled(false);
	connect(mimeButtonNew,SIGNAL(clicked()),this,SLOT(mimeNewClicked()));
	connect(mimeButtonDelete,SIGNAL(clicked()),this,SLOT(mimeDeleteClicked()));
	connect(mimeDirButton,SIGNAL(clicked()),this,SLOT(mimeDirClicked()));

	// jetzt in einer schleife alle vorhandenen Mimetypen einlesen
	KConfig *config;
	config = kapp->getConfig();
	config->setGroup("MimeTypes");
	int i=0;
	bool flag = false;
	QString mimeKey, mimeProg;
	do
	{
		flag = false;
		mimeKey.sprintf("Extender%d",i);
		mimeProg.sprintf("start with%d",i);
		if(config->hasKey(mimeKey))
		{
			flag = true;
			mimeList->insertItem(config->readEntry(mimeKey));
			mimeProgList->insertItem(config->readEntry(mimeProg));
		}
		i++;

	}
	while(flag);
	
	
	l1 = new QLabel(i18n("Starting with :"),seite4);
	l1->setGeometry(QRect(QPoint(280,80),l1->sizeHint()));
	leMimeProc = new QLineEdit(seite4);
	leMimeProc->setGeometry(280,100,190,20);
	connect(leMimeProc,SIGNAL(textChanged( const char *)),this,SLOT(textChanged( const char * )));
	
	
	
	// finally insert page one into the tab dialog and start GM
	tab->addTab( seite4, i18n("&Fileextensions") );

// ***************   TABS FERTIG ! ******************************


showPage(seite3);

connect( tab, SIGNAL(applyButtonPressed()), SLOT(apply()) );
connect( tab, SIGNAL(cancelButtonPressed()), SLOT(setup()) );
connect( tab, SIGNAL(aboutToShow()), SLOT(setup()) );
	
}



dlgOptions::~dlgOptions()
{
		delete bg;
		delete bg2;
}

void dlgOptions::setup()
{
	// Hier aus den Optionen holen & setzen
	KConfig *config;
	config = kapp->getConfig();
	
	config->setGroup("Packer");
	QString s = config->readEntry("Methode","gzip");
	if(s == "gzip")
		bg2->setButton(0);
	if(s == "bzip2")
		bg2->setButton(1);
	if(s == "compress")
		bg2->setButton(2);

	s = config->readEntry("Wo Packen","extern");
	if(s == "normal")
		bg->setButton(0);
	if(s == "extern")
		bg->setButton(1);
	if(s == "fragen")
		bg->setButton(2);
}

void dlgOptions::apply()
{
		lv1->backgroundColor = cb1->color();
		lv1->selBackgroundColor = cb2->color();
		lv1->forgroundColor = cb3->color();
		lv1->selForgroundColor = cb4->color();
		lv1->cursorColor = cb5->color();
		lv1->cursorColorSelected = cb6->color();
		lv1->cursorTextColor = cb7->color();
		lv1->cursorTextColorSelected = cb8->color();
		lv1->cursorRand = cb9->color();
		
		
		lv2->backgroundColor = cb1->color();
		lv2->selBackgroundColor = cb2->color();
		lv2->forgroundColor = cb3->color();
		lv2->selForgroundColor = cb4->color();
		lv2->cursorColor = cb5->color();
		lv2->cursorColorSelected = cb6->color();
		lv2->cursorTextColor = cb7->color();
		lv2->cursorTextColorSelected = cb8->color();
		lv2->cursorRand = cb9->color();
		
		lv1->refreshListview();
		lv2->refreshListview();

		KConfig *config;
		config = kapp->getConfig();
		config->setGroup("Packer");
		
		QString s;
		if(b4->isChecked())
			s = "gzip";
   	else if(b5->isChecked())
			s = "bzip2";
		config->writeEntry("Methode",s);


		if(b1->isChecked())
			s = "normal";
   	else if(b2->isChecked())
			s = "extern";
   	else if(b3->isChecked())
			s = "fragen";
		config->writeEntry("Wo Packen",s);
//*********************************************************	
		config->setGroup("Abfragen");
		if(cf1->isChecked())
			config->writeEntry("delete files","yes");
		else
			config->writeEntry("delete files","no");
		if(cf2->isChecked())
			config->writeEntry("overwrite files","yes");
		else
			config->writeEntry("overwrite files","no");
		if(cf3->isChecked())
			config->writeEntry("exit commander","yes");
		else
			config->writeEntry("exit commander","no");




		config->setGroup("MimeTypes");
		for(int i=0;i < (signed)mimeList->count();i++)
		{
			s.sprintf("Extender%d",i);
			config->writeEntry(s,mimeList->text(i));
			s.sprintf("start with%d",i);
			config->writeEntry(s,mimeProgList->text(i));
		}

}

void dlgOptions::selected ( const char * tabLabel )
{
		debug("name");
		debug(tabLabel);
}

void dlgOptions::filledClicked()
{
	lv1->cursorFilled = cf->isChecked();
	lv2->cursorFilled = cf->isChecked();
	if(cf->isChecked())
	{
		cb5->setEnabled(true);
		cb6->setEnabled(true);
		cb7->setEnabled(true);
		cb8->setEnabled(true);
	}
	else
	{
		cb5->setEnabled(false);
		cb6->setEnabled(false);
		cb7->setEnabled(false);
		cb8->setEnabled(false);
	}
}


void dlgOptions::mimeNewClicked()
{
  		InputBox ip(this,i18n("New Extension :"));
  		int code =  ip.exec();
    	if(code != 0)
    	{
			mimeList->insertItem(ip.me->text());
			mimeProgList->insertItem(QString(i18n("Application for ")) + ip.me->text());
			mimeTypeClicked(mimeList->count()-1);
			mimeList->setCurrentItem(mimeList->count()-1);
			leMimeProc->setFocus();
		}

}
void dlgOptions::mimeDeleteClicked()
{
	int c = mimeList->currentItem();
	mimeList->removeItem(c);
	mimeProgList->removeItem(c);
	
	c = mimeList->currentItem();
	if(c > -1)
		leMimeProc->setText(mimeProgList->text(c));
	else
	{
		leMimeProc->setText("");
		mimeButtonDelete->setEnabled(false);
		mimeDirButton->setEnabled(false);
	}
	
}


void dlgOptions::mimeTypeClicked(int index)
{
	mimeDirButton->setEnabled(true);
	mimeButtonDelete->setEnabled(true);
	leMimeProc->setText(mimeProgList->text(index));
	mimeProgList->setCurrentItem(index);
	leMimeProc->setFocus();
}


void dlgOptions::textChanged ( const char *s )
{
	int i = mimeList->currentItem();
	mimeProgList->changeItem(s,i);
}

void dlgOptions::mimeDirClicked()
{
	QString s;
	browseFile = new KFileDialog("/");
	s = browseFile->getOpenFileName();
	
	if(s.length() != 0)
		leMimeProc->setText(s);
}




